/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.conf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.util.Copiable;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.StringUtils;
import org.jetbrains.annotations.TestOnly;

public class Configuration
implements Iterable<PeerId>,
Copiable<Configuration> {
    private static final IgniteLogger LOG = Loggers.forClass(Configuration.class);
    private static final String LEARNER_POSTFIX = "/learner";
    public static final long NO_SEQUENCE_TOKEN = 0L;
    private List<PeerId> peers = new ArrayList<PeerId>();
    private LinkedHashSet<PeerId> learners = new LinkedHashSet();
    private long sequenceToken;

    public Configuration() {
    }

    public Configuration(long sequenceToken) {
        this.sequenceToken = sequenceToken;
    }

    public Configuration(Iterable<PeerId> conf, long sequenceToken) {
        this(conf, null, sequenceToken);
    }

    @TestOnly
    public Configuration(Iterable<PeerId> conf) {
        this(conf, 0L);
    }

    public Configuration(Configuration conf) {
        this(conf.getPeers(), conf.getLearners(), conf.getSequenceToken());
    }

    public Configuration(Configuration conf, long sequenceToken) {
        this(conf.getPeers(), conf.getLearners(), sequenceToken);
    }

    public Configuration(Iterable<PeerId> conf, Iterable<PeerId> learners, long sequenceToken) {
        Requires.requireNonNull(conf, "conf");
        this.sequenceToken = sequenceToken;
        for (PeerId peer : conf) {
            this.peers.add(peer.copy());
        }
        this.addLearners(learners);
    }

    @TestOnly
    public Configuration(Iterable<PeerId> conf, Iterable<PeerId> learners) {
        this(conf, learners, 0L);
    }

    public void setLearners(LinkedHashSet<PeerId> learners) {
        this.learners = learners;
    }

    public boolean addLearner(PeerId learner) {
        return this.learners.add(learner);
    }

    public int addLearners(Iterable<PeerId> learners) {
        int ret = 0;
        if (learners != null) {
            for (PeerId peer : learners) {
                if (!this.learners.add(peer.copy())) continue;
                ++ret;
            }
        }
        return ret;
    }

    public boolean removeLearner(PeerId learner) {
        return this.learners.remove(learner);
    }

    public LinkedHashSet<PeerId> getLearners() {
        return this.learners;
    }

    public long getSequenceToken() {
        return this.sequenceToken;
    }

    public List<PeerId> listLearners() {
        return new ArrayList<PeerId>(this.learners);
    }

    @Override
    public Configuration copy() {
        return new Configuration(this.peers, this.learners, this.sequenceToken);
    }

    public boolean isValid() {
        HashSet<PeerId> intersection = new HashSet<PeerId>(this.peers);
        intersection.retainAll(this.learners);
        return !this.peers.isEmpty() && intersection.isEmpty();
    }

    public void reset() {
        this.peers.clear();
        this.learners.clear();
    }

    public boolean isEmpty() {
        return this.peers.isEmpty();
    }

    public int size() {
        return this.peers.size();
    }

    @Override
    public Iterator<PeerId> iterator() {
        return this.peers.iterator();
    }

    public Set<PeerId> getPeerSet() {
        return new HashSet<PeerId>(this.peers);
    }

    public List<PeerId> listPeers() {
        return new ArrayList<PeerId>(this.peers);
    }

    public List<PeerId> getPeers() {
        return this.peers;
    }

    public void setPeers(List<PeerId> peers) {
        this.peers.clear();
        for (PeerId peer : peers) {
            this.peers.add(peer.copy());
        }
    }

    public void appendPeers(Collection<PeerId> set) {
        this.peers.addAll(set);
    }

    public boolean addPeer(PeerId peer) {
        return this.peers.add(peer);
    }

    public boolean removePeer(PeerId peer) {
        return this.peers.remove(peer);
    }

    public boolean contains(PeerId peer) {
        return this.peers.contains(peer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.learners == null ? 0 : this.learners.hashCode());
        result = 31 * result + (this.peers == null ? 0 : this.peers.hashCode());
        result = 31 * result + (int)this.sequenceToken;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (this.sequenceToken != other.sequenceToken) {
            return false;
        }
        if (this.learners == null ? other.learners != null : !this.learners.equals(other.learners)) {
            return false;
        }
        if (this.peers == null) {
            return other.peers == null;
        }
        return this.peers.equals(other.peers);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<PeerId> peers = this.listPeers();
        int i = 0;
        int size = peers.size();
        for (PeerId peer : peers) {
            sb.append(peer);
            if (i < size - 1 || !this.learners.isEmpty()) {
                sb.append(",");
            }
            ++i;
        }
        size = this.learners.size();
        i = 0;
        for (PeerId peer : this.learners) {
            sb.append(peer).append(LEARNER_POSTFIX);
            if (i < size - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean parse(String conf) {
        String[] peerStrs;
        if (StringUtils.isBlank(conf)) {
            return false;
        }
        this.reset();
        for (String peerStr : peerStrs = StringUtils.split(conf, ',')) {
            PeerId peer = new PeerId();
            boolean isLearner = false;
            int index = peerStr.indexOf(LEARNER_POSTFIX);
            if (index > 0) {
                peerStr = peerStr.substring(0, index);
                isLearner = true;
            }
            if (peer.parse(peerStr)) {
                if (isLearner) {
                    this.addLearner(peer);
                    continue;
                }
                this.addPeer(peer);
                continue;
            }
            LOG.error("Fail to parse peer {} in {}, ignore it.", new Object[]{peerStr, conf});
        }
        return true;
    }

    public void diff(Configuration rhs, Configuration included, Configuration excluded) {
        included.peers = new ArrayList<PeerId>(this.peers);
        included.peers.removeAll(rhs.peers);
        excluded.peers = new ArrayList<PeerId>(rhs.peers);
        excluded.peers.removeAll(this.peers);
    }

    @TestOnly
    public void updateSequenceToken(long sequenceToken) {
        this.sequenceToken = sequenceToken;
    }
}

