/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.server.impl;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.raft.JraftGroupEventsListener;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.raft.PeersAndLearners;
import org.apache.ignite.internal.raft.RaftError;
import org.apache.ignite.internal.raft.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.Status;
import org.apache.ignite.internal.raft.server.impl.RaftServiceEventInterceptor;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.raft.jraft.entity.PeerId;

class RaftGroupEventsListenerAdapter
implements JraftGroupEventsListener {
    private final RaftServiceEventInterceptor serviceEventInterceptor;
    private final RaftGroupEventsListener delegate;
    private final ReplicationGroupId grpId;

    RaftGroupEventsListenerAdapter(ReplicationGroupId grpId, RaftServiceEventInterceptor serviceEventInterceptor, RaftGroupEventsListener delegate) {
        this.grpId = grpId;
        this.serviceEventInterceptor = serviceEventInterceptor;
        this.delegate = delegate;
    }

    @Override
    public void onLeaderElected(long term, long configurationTerm, long configurationIndex, Collection<PeerId> peers, Collection<PeerId> learners, long sequenceToken) {
        this.serviceEventInterceptor.onLeaderElected(this.grpId, term);
        this.delegate.onLeaderElected(term, configurationTerm, configurationIndex, RaftGroupEventsListenerAdapter.configuration(peers, learners), sequenceToken);
    }

    @Override
    public void onNewPeersConfigurationApplied(Collection<PeerId> peerIds, Collection<PeerId> learnerIds, long term, long index, long sequenceToken) {
        this.delegate.onNewPeersConfigurationApplied(RaftGroupEventsListenerAdapter.configuration(peerIds, learnerIds), term, index, sequenceToken);
    }

    @Override
    public void onReconfigurationError(org.apache.ignite.raft.jraft.Status status, Collection<PeerId> peerIds, Collection<PeerId> learnerIds, long term, long sequenceToken) {
        this.delegate.onReconfigurationError(RaftGroupEventsListenerAdapter.convertStatus(status), RaftGroupEventsListenerAdapter.configuration(peerIds, learnerIds), term, sequenceToken);
    }

    protected static PeersAndLearners configuration(Collection<PeerId> peerIds, Collection<PeerId> learnerIds) {
        return PeersAndLearners.fromPeers(RaftGroupEventsListenerAdapter.peerIdsToPeers(peerIds), RaftGroupEventsListenerAdapter.peerIdsToPeers(learnerIds));
    }

    private static Set<Peer> peerIdsToPeers(Collection<PeerId> ids) {
        return ids.stream().map(id -> new Peer(id.getConsistentId(), id.getIdx())).collect(Collectors.toUnmodifiableSet());
    }

    private static Status convertStatus(org.apache.ignite.raft.jraft.Status status) {
        return new Status(RaftGroupEventsListenerAdapter.convertError(status.getRaftError()), status.getErrorMsg());
    }

    private static RaftError convertError(org.apache.ignite.raft.jraft.error.RaftError error) {
        switch (error) {
            case SUCCESS: {
                return RaftError.SUCCESS;
            }
            case ECATCHUP: {
                return RaftError.ECATCHUP;
            }
            case EPERM: {
                return RaftError.EPERM;
            }
        }
        return RaftError.OTHER;
    }
}

