/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util.timer;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.raft.jraft.core.Scheduler;
import org.apache.ignite.raft.jraft.core.TimerManager;
import org.apache.ignite.raft.jraft.util.timer.HashedWheelTimer;
import org.apache.ignite.raft.jraft.util.timer.RaftTimerFactory;
import org.apache.ignite.raft.jraft.util.timer.Timer;

public class DefaultRaftTimerFactory
implements RaftTimerFactory {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultRaftTimerFactory.class);

    @Override
    public Timer getElectionTimer(String name) {
        return this.createTimer(name);
    }

    @Override
    public Timer getVoteTimer(String name) {
        return this.createTimer(name);
    }

    @Override
    public Timer getStepDownTimer(String name) {
        return this.createTimer(name);
    }

    @Override
    public Timer getSnapshotTimer(String name) {
        return this.createTimer(name);
    }

    @Override
    public Timer createTimer(String name) {
        return new HashedWheelTimer((ThreadFactory)IgniteThreadFactory.createWithFixedPrefix((String)name, (boolean)true, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]), 1L, TimeUnit.MILLISECONDS, 2048);
    }

    @Override
    public Scheduler createScheduler(int workerNum, String name) {
        return new TimerManager(workerNum, name);
    }
}

