/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaImpl;
import org.jetbrains.annotations.Nullable;

public class CompatibleJDKMarshaller
implements Marshaller {
    public static final Marshaller INSTANCE = new CompatibleJDKMarshaller();

    public byte[] marshall(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public <T> T unmarshall(ByteBuffer raw) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(raw.array(), raw.arrayOffset() + raw.position(), raw.remaining());
            CompatibilityObjectInputStream oos = new CompatibilityObjectInputStream(bais);
            return (T)oos.readObject();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static class CompatibilityObjectInputStream
    extends ObjectInputStream {
        private static final long SERIAL_VERSION_ID_BEFORE_ADDING_SEQUENCE_TOKENS = -6673992096916801742L;
        private static final long SERIAL_VERSION_ID_AFTER_ADDING_SEQUENCE_TOKENS = 7302290474182723103L;
        private boolean readingClassDescriptor;
        @Nullable
        private String className;

        private CompatibilityObjectInputStream(ByteArrayInputStream bais) throws IOException {
            super(bais);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            this.readingClassDescriptor = true;
            try {
                ObjectStreamClass objectStreamClass = super.readClassDescriptor();
                return objectStreamClass;
            }
            finally {
                this.readingClassDescriptor = false;
            }
        }

        @Override
        public String readUTF() throws IOException {
            String str = super.readUTF();
            if (this.readingClassDescriptor) {
                this.className = str;
            }
            return str;
        }

        @Override
        public long readLong() throws IOException {
            long value = super.readLong();
            if (this.readingClassDescriptor) {
                if (SnapshotMetaImpl.class.getName().equals(this.className) && value == -6673992096916801742L) {
                    value = 7302290474182723103L;
                }
                this.className = null;
                this.readingClassDescriptor = false;
            }
            return value;
        }
    }
}

