/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.ReadActionRequest;
import org.apache.ignite.raft.jraft.rpc.ReadActionRequestImpl;

class ReadActionRequestSerializer
implements MessageSerializer<ReadActionRequest> {
    public static final ReadActionRequestSerializer INSTANCE = new ReadActionRequestSerializer();

    private ReadActionRequestSerializer() {
    }

    public boolean writeMessage(ReadActionRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadActionRequestImpl message = (ReadActionRequestImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.readActionRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("command", (NetworkMessage)message.command());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoolean("readOnlySafe", message.readOnlySafe());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

