/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.entity.EntryMetaBuilder;
import org.apache.ignite.raft.jraft.entity.EntryMetaSerializer;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.RaftOutter;

public class EntryMetaImpl
implements RaftOutter.EntryMeta,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 2000;
    @IgniteToStringInclude
    private final long checksum;
    @IgniteToStringInclude
    private final long dataLen;
    @IgniteToStringInclude
    private final boolean hasChecksum;
    @IgniteToStringInclude
    private final Collection<String> learnersList;
    @IgniteToStringInclude
    private final Collection<String> oldLearnersList;
    @IgniteToStringInclude
    private final Collection<String> oldPeersList;
    @IgniteToStringInclude
    private final Collection<String> peersList;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private final EnumOutter.EntryType type;
    @IgniteToStringInclude
    private final long oldSequenceToken;
    @IgniteToStringInclude
    private final long sequenceToken;

    private EntryMetaImpl(long checksum, long dataLen, boolean hasChecksum, Collection<String> learnersList, Collection<String> oldLearnersList, Collection<String> oldPeersList, Collection<String> peersList, long term, EnumOutter.EntryType type, long oldSequenceToken, long sequenceToken) {
        this.checksum = checksum;
        this.dataLen = dataLen;
        this.hasChecksum = hasChecksum;
        this.learnersList = learnersList;
        this.oldLearnersList = oldLearnersList;
        this.oldPeersList = oldPeersList;
        this.peersList = peersList;
        this.term = term;
        this.type = type;
        this.oldSequenceToken = oldSequenceToken;
        this.sequenceToken = sequenceToken;
    }

    @Override
    public long checksum() {
        return this.checksum;
    }

    @Override
    public long dataLen() {
        return this.dataLen;
    }

    @Override
    public boolean hasChecksum() {
        return this.hasChecksum;
    }

    @Override
    public Collection<String> learnersList() {
        return this.learnersList;
    }

    @Override
    public Collection<String> oldLearnersList() {
        return this.oldLearnersList;
    }

    @Override
    public Collection<String> oldPeersList() {
        return this.oldPeersList;
    }

    @Override
    public Collection<String> peersList() {
        return this.peersList;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public EnumOutter.EntryType type() {
        return this.type;
    }

    @Override
    public long oldSequenceToken() {
        return this.oldSequenceToken;
    }

    @Override
    public long sequenceToken() {
        return this.sequenceToken;
    }

    public MessageSerializer serializer() {
        return EntryMetaSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(EntryMetaImpl.class, (Object)this);
    }

    public short messageType() {
        return 2000;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EntryMetaImpl otherMessage = (EntryMetaImpl)other;
        return Objects.equals(this.learnersList, otherMessage.learnersList) && Objects.equals(this.oldLearnersList, otherMessage.oldLearnersList) && Objects.equals(this.oldPeersList, otherMessage.oldPeersList) && Objects.equals(this.peersList, otherMessage.peersList) && Objects.equals((Object)this.type, (Object)otherMessage.type) && this.checksum == otherMessage.checksum && this.dataLen == otherMessage.dataLen && this.hasChecksum == otherMessage.hasChecksum && this.term == otherMessage.term && this.oldSequenceToken == otherMessage.oldSequenceToken && this.sequenceToken == otherMessage.sequenceToken;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(new Object[]{this.checksum, this.dataLen, this.hasChecksum, this.term, this.oldSequenceToken, this.sequenceToken, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList, this.type});
        return result;
    }

    public EntryMetaImpl clone() {
        try {
            return (EntryMetaImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static EntryMetaBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements EntryMetaBuilder {
        private long checksum;
        private long dataLen;
        private boolean hasChecksum;
        private Collection<String> learnersList;
        private Collection<String> oldLearnersList;
        private Collection<String> oldPeersList;
        private Collection<String> peersList;
        private long term;
        private EnumOutter.EntryType type;
        private long oldSequenceToken;
        private long sequenceToken;

        private Builder() {
        }

        @Override
        public EntryMetaBuilder checksum(long checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public EntryMetaBuilder dataLen(long dataLen) {
            this.dataLen = dataLen;
            return this;
        }

        @Override
        public EntryMetaBuilder hasChecksum(boolean hasChecksum) {
            this.hasChecksum = hasChecksum;
            return this;
        }

        @Override
        public EntryMetaBuilder learnersList(Collection<String> learnersList) {
            this.learnersList = learnersList;
            return this;
        }

        @Override
        public EntryMetaBuilder oldLearnersList(Collection<String> oldLearnersList) {
            this.oldLearnersList = oldLearnersList;
            return this;
        }

        @Override
        public EntryMetaBuilder oldPeersList(Collection<String> oldPeersList) {
            this.oldPeersList = oldPeersList;
            return this;
        }

        @Override
        public EntryMetaBuilder peersList(Collection<String> peersList) {
            this.peersList = peersList;
            return this;
        }

        @Override
        public EntryMetaBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public EntryMetaBuilder type(EnumOutter.EntryType type) {
            Objects.requireNonNull(type, "type is not marked @Nullable");
            this.type = type;
            return this;
        }

        @Override
        public EntryMetaBuilder oldSequenceToken(long oldSequenceToken) {
            this.oldSequenceToken = oldSequenceToken;
            return this;
        }

        @Override
        public EntryMetaBuilder sequenceToken(long sequenceToken) {
            this.sequenceToken = sequenceToken;
            return this;
        }

        @Override
        public long checksum() {
            return this.checksum;
        }

        @Override
        public long dataLen() {
            return this.dataLen;
        }

        @Override
        public boolean hasChecksum() {
            return this.hasChecksum;
        }

        @Override
        public Collection<String> learnersList() {
            return this.learnersList;
        }

        @Override
        public Collection<String> oldLearnersList() {
            return this.oldLearnersList;
        }

        @Override
        public Collection<String> oldPeersList() {
            return this.oldPeersList;
        }

        @Override
        public Collection<String> peersList() {
            return this.peersList;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public EnumOutter.EntryType type() {
            return this.type;
        }

        @Override
        public long oldSequenceToken() {
            return this.oldSequenceToken;
        }

        @Override
        public long sequenceToken() {
            return this.sequenceToken;
        }

        @Override
        public RaftOutter.EntryMeta build() {
            return new EntryMetaImpl(this.checksum, this.dataLen, this.hasChecksum, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList, this.term, Objects.requireNonNull(this.type, "type is not marked @Nullable"), this.oldSequenceToken, this.sequenceToken);
        }

        @Override
        public RaftOutter.EntryMeta buildDeserialized() {
            return new EntryMetaImpl(this.checksum, this.dataLen, this.hasChecksum, this.learnersList, this.oldLearnersList, this.oldPeersList, this.peersList, this.term, this.type, this.oldSequenceToken, this.sequenceToken);
        }
    }
}

