/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.Arrays;

class SegmentInfo {
    private static final VarHandle SEGMENT_FILE_OFFSETS_VH;
    private final long logIndexBase;
    private volatile ArrayWithSize segmentFileOffsets = new ArrayWithSize();

    SegmentInfo(long logIndexBase) {
        this.logIndexBase = logIndexBase;
    }

    void addOffset(long logIndex, int segmentFileOffset) {
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        assert ((long)segmentFileOffsets.size() == logIndex - this.logIndexBase) : String.format("Log indexes are not monotonically increasing [logIndex=%d, expectedLogIndex=%d].", logIndex, this.logIndexBase + (long)segmentFileOffsets.size());
        ArrayWithSize newSegmentFileOffsets = segmentFileOffsets.add(segmentFileOffset);
        boolean updated = SEGMENT_FILE_OFFSETS_VH.compareAndSet(this, segmentFileOffsets, newSegmentFileOffsets);
        assert (updated) : "Concurrent writes detected";
    }

    int getOffset(long logIndex) {
        long offsetIndex = logIndex - this.logIndexBase;
        if (offsetIndex < 0L) {
            return 0;
        }
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        if (offsetIndex >= (long)segmentFileOffsets.size()) {
            return 0;
        }
        return segmentFileOffsets.get((int)offsetIndex);
    }

    long firstLogIndexInclusive() {
        return this.logIndexBase;
    }

    long lastLogIndexExclusive() {
        return this.logIndexBase + (long)this.segmentFileOffsets.size();
    }

    int size() {
        return this.segmentFileOffsets.size();
    }

    void saveOffsetsTo(ByteBuffer buffer) {
        ArrayWithSize offsets = this.segmentFileOffsets;
        buffer.asIntBuffer().put(offsets.array, 0, offsets.size);
    }

    void truncateSuffix(long lastLogIndexKept) {
        assert (lastLogIndexKept >= this.logIndexBase) : String.format("logIndexBase=%d, lastLogIndexKept=%d", this.logIndexBase, lastLogIndexKept);
        long newSize = lastLogIndexKept - this.logIndexBase + 1L;
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        if (newSize > (long)segmentFileOffsets.size()) {
            throw new IllegalArgumentException(String.format("lastLogIndexKept is too large. Last index in memtable: %d, lastLogIndexKept: %d", this.logIndexBase + (long)segmentFileOffsets.size() - 1L, lastLogIndexKept));
        }
        ArrayWithSize newSegmentFileOffsets = segmentFileOffsets.truncate((int)newSize);
        boolean updated = SEGMENT_FILE_OFFSETS_VH.compareAndSet(this, segmentFileOffsets, newSegmentFileOffsets);
        assert (updated) : "Concurrent writes detected";
    }

    static {
        try {
            SEGMENT_FILE_OFFSETS_VH = MethodHandles.lookup().findVarHandle(SegmentInfo.class, "segmentFileOffsets", ArrayWithSize.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ArrayWithSize {
        private static final int INITIAL_CAPACITY = 10;
        private final int[] array;
        private final int size;

        ArrayWithSize() {
            this(new int[10], 0);
        }

        private ArrayWithSize(int[] array, int size) {
            this.array = array;
            this.size = size;
        }

        ArrayWithSize add(int element) {
            int[] array = this.array;
            if (this.size == array.length) {
                array = Arrays.copyOf(array, array.length * 2);
            }
            array[this.size] = element;
            return new ArrayWithSize(array, this.size + 1);
        }

        ArrayWithSize truncate(int newSize) {
            assert (newSize <= this.size) : String.format("Array must shrink on truncation, current size: %d, size after truncation: %d", this.size, newSize);
            int[] newArray = new int[this.size];
            System.arraycopy(this.array, 0, newArray, 0, newSize);
            return new ArrayWithSize(newArray, newSize);
        }

        int get(int index) {
            return this.array[index];
        }

        int size() {
            return this.size;
        }
    }
}

