/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import org.apache.ignite.internal.tostring.S;

class IndexFileMeta {
    private final long firstLogIndexInclusive;
    private final long lastLogIndexExclusive;
    private final int indexFilePayloadOffset;
    private final int indexFileOrdinal;

    IndexFileMeta(long firstLogIndexInclusive, long lastLogIndexExclusive, int indexFilePayloadOffset, int indexFileOrdinal) {
        if (lastLogIndexExclusive < firstLogIndexInclusive) {
            throw new IllegalArgumentException("Invalid log index range: [" + firstLogIndexInclusive + ", " + lastLogIndexExclusive + ").");
        }
        if (indexFileOrdinal < 0) {
            throw new IllegalArgumentException("Invalid index file ordinal: " + indexFileOrdinal);
        }
        this.firstLogIndexInclusive = firstLogIndexInclusive;
        this.lastLogIndexExclusive = lastLogIndexExclusive;
        this.indexFilePayloadOffset = indexFilePayloadOffset;
        this.indexFileOrdinal = indexFileOrdinal;
    }

    long firstLogIndexInclusive() {
        return this.firstLogIndexInclusive;
    }

    long lastLogIndexExclusive() {
        return this.lastLogIndexExclusive;
    }

    int indexFilePayloadOffset() {
        return this.indexFilePayloadOffset;
    }

    int indexFileOrdinal() {
        return this.indexFileOrdinal;
    }

    boolean isEmpty() {
        return this.firstLogIndexInclusive == this.lastLogIndexExclusive;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexFileMeta that = (IndexFileMeta)o;
        return this.firstLogIndexInclusive == that.firstLogIndexInclusive && this.lastLogIndexExclusive == that.lastLogIndexExclusive && this.indexFilePayloadOffset == that.indexFilePayloadOffset && this.indexFileOrdinal == that.indexFileOrdinal;
    }

    public int hashCode() {
        int result = Long.hashCode(this.firstLogIndexInclusive);
        result = 31 * result + Long.hashCode(this.lastLogIndexExclusive);
        result = 31 * result + this.indexFilePayloadOffset;
        result = 31 * result + this.indexFileOrdinal;
        return result;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

