/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.storage.impl.DefaultLogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorageUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.conf.ConfigurationEntry;
import org.apache.ignite.raft.jraft.conf.ConfigurationManager;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.LogId;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite.raft.jraft.option.LogStorageOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.util.BytesUtil;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.Utils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class RocksDbSharedLogStorage
implements LogStorage,
Describer {
    private static final IgniteLogger LOG = Loggers.forClass(RocksDbSharedLogStorage.class);
    private static final VarHandle LONG_ARRAY_HANDLE;
    private static final long INITIAL_INDEX = 1L;
    private static final byte[] FIRST_LOG_IDX_KEY;
    private final DefaultLogStorageFactory logStorageFactory;
    private final RocksDB db;
    private final ColumnFamilyHandle metaHandle;
    private final ColumnFamilyHandle confHandle;
    private final ColumnFamilyHandle dataHandle;
    private final WriteOptions writeOptions;
    private final String raftNodeStorageId;
    private final byte[] startPrefix;
    private final byte[] endPrefix;
    private final Slice startBound;
    private final Slice endBound;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock useLock = this.readWriteLock.readLock();
    private final Lock manageLock = this.readWriteLock.writeLock();
    private boolean stopped = false;
    private final Executor executor;
    private LogEntryEncoder logEntryEncoder;
    private LogEntryDecoder logEntryDecoder;
    private volatile long firstLogIndex = 1L;
    private volatile boolean hasLoadFirstLogIndex;

    RocksDbSharedLogStorage(DefaultLogStorageFactory logStorageFactory, RocksDB db, ColumnFamilyHandle metaHandle, ColumnFamilyHandle confHandle, ColumnFamilyHandle dataHandle, String raftNodeStorageId, WriteOptions writeOptions, Executor executor) {
        Requires.requireNonNull(db);
        Requires.requireNonNull(confHandle);
        Requires.requireNonNull(dataHandle);
        Requires.requireNonNull(executor);
        Requires.requireTrue(raftNodeStorageId.indexOf(0) == -1, "Raft node storage id " + raftNodeStorageId + " must not contain char(0)");
        Requires.requireTrue(raftNodeStorageId.indexOf(1) == -1, "Raft node storage id " + raftNodeStorageId + " must not contain char(1)");
        this.logStorageFactory = logStorageFactory;
        this.db = db;
        this.metaHandle = metaHandle;
        this.confHandle = confHandle;
        this.dataHandle = dataHandle;
        this.executor = executor;
        this.raftNodeStorageId = raftNodeStorageId;
        this.startPrefix = RocksDbSharedLogStorageUtils.raftNodeStorageStartPrefix(raftNodeStorageId);
        this.endPrefix = RocksDbSharedLogStorageUtils.raftNodeStorageEndPrefix(raftNodeStorageId);
        this.startBound = new Slice(this.startPrefix);
        this.endBound = new Slice(this.endPrefix);
        this.writeOptions = writeOptions;
    }

    static byte[] storageCreatedKey(String raftNodeStorageId) {
        return ArrayUtils.concat((byte[])DefaultLogStorageFactory.STORAGE_CREATED_META_PREFIX, (byte[])raftNodeStorageId.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        Requires.requireNonNull(opts.getConfigurationManager(), "Null conf manager");
        Requires.requireNonNull(opts.getLogEntryCodecFactory(), "Null log entry codec factory");
        this.manageLock.lock();
        try {
            this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
            this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
            Requires.requireNonNull(this.logEntryDecoder, "Null log entry decoder");
            Requires.requireNonNull(this.logEntryEncoder, "Null log entry encoder");
            this.saveStorageCreatedFlag();
            boolean bl = this.initAndLoad(opts.getConfigurationManager());
            return bl;
        }
        finally {
            this.manageLock.unlock();
        }
    }

    private void saveStorageCreatedFlag() {
        try (WriteBatch writeBatch = new WriteBatch();){
            RocksDbSharedLogStorage.saveStorageStartedFlag(this.metaHandle, this.raftNodeStorageId, writeBatch);
            this.db.write(this.writeOptions, writeBatch);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    static void saveStorageStartedFlag(ColumnFamilyHandle metaHandle, String raftNodeStorageId, WriteBatch writeBatch) throws RocksDBException {
        byte[] storageCreatedKey = RocksDbSharedLogStorage.storageCreatedKey(raftNodeStorageId);
        writeBatch.put(metaHandle, storageCreatedKey, ArrayUtils.BYTE_EMPTY_ARRAY);
    }

    private boolean initAndLoad(ConfigurationManager configurationManager) {
        this.hasLoadFirstLogIndex = false;
        this.firstLogIndex = 1L;
        this.load(configurationManager);
        return this.onInitLoaded();
    }

    private void load(ConfigurationManager confManager) {
        try (ReadOptions readOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)this.endBound);
             RocksIterator it = this.db.newIterator(this.confHandle, readOptions);){
            it.seek(this.startPrefix);
            while (it.isValid()) {
                byte[] keyWithPrefix = it.key();
                byte[] ks = this.extractKey(keyWithPrefix);
                byte[] bs = it.value();
                if (ks.length == 8) {
                    LogEntry entry = this.logEntryDecoder.decode(bs);
                    if (entry != null) {
                        if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                            ConfigurationEntry confEntry = new ConfigurationEntry();
                            confEntry.setId(new LogId(entry.getId().getIndex(), entry.getId().getTerm()));
                            confEntry.setConf(new Configuration(entry.getPeers(), entry.getLearners(), entry.getSequenceToken()));
                            if (entry.getOldPeers() != null) {
                                confEntry.setOldConf(new Configuration(entry.getOldPeers(), entry.getOldLearners(), entry.getOldSequenceToken()));
                            }
                            if (confManager != null) {
                                confManager.add(confEntry);
                            }
                        }
                    } else {
                        LOG.warn("Fail to decode conf entry at index {}, the log data is: {}.", new Object[]{LONG_ARRAY_HANDLE.get(ks, 0), BytesUtil.toHex(bs)});
                    }
                } else if (Arrays.equals(FIRST_LOG_IDX_KEY, ks)) {
                    this.setFirstLogIndex(LONG_ARRAY_HANDLE.get(bs, 0));
                    this.truncatePrefixInBackground(0L, this.firstLogIndex);
                } else {
                    LOG.warn("Unknown entry in configuration storage key={}, value={}.", new Object[]{BytesUtil.toHex(ks), BytesUtil.toHex(bs)});
                }
                it.next();
            }
        }
    }

    private byte[] extractKey(byte[] ks) {
        return RocksDbSharedLogStorage.extractKey(ks, this.startPrefix);
    }

    private static byte[] extractKey(byte[] ks, byte[] startPrefix) {
        return Arrays.copyOfRange(ks, startPrefix.length, ks.length);
    }

    private void setFirstLogIndex(long index) {
        this.firstLogIndex = index;
        this.hasLoadFirstLogIndex = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFirstLogIndex(long firstLogIndex) {
        this.useLock.lock();
        try {
            byte[] vs = new byte[8];
            LONG_ARRAY_HANDLE.set(vs, 0, firstLogIndex);
            this.db.put(this.confHandle, this.writeOptions, this.createKey(FIRST_LOG_IDX_KEY), vs);
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to save first log index {}.", (Throwable)e, new Object[]{firstLogIndex});
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.manageLock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            this.onShutdown();
        }
        finally {
            this.manageLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getFirstLogIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getLastLogIndex() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LogEntry getEntry(long index) {
        this.useLock.lock();
        try {
            if (this.hasLoadFirstLogIndex && index < this.firstLogIndex) {
                LogEntry logEntry = null;
                return logEntry;
            }
            byte[] keyBytes = this.createKey(index);
            byte[] bs = this.getValueFromRocksDb(keyBytes);
            if (bs != null) {
                LogEntry entry = this.logEntryDecoder.decode(bs);
                if (entry != null) {
                    LogEntry logEntry = entry;
                    return logEntry;
                }
                LOG.error("Bad log entry format for index={}, the log data is: {}.", new Object[]{index, BytesUtil.toHex(bs)});
                LogEntry logEntry = null;
                return logEntry;
            }
        }
        catch (RocksDBException e) {
            LOG.error("Fail to get log entry at index {}.", (Throwable)e, new Object[]{index});
        }
        finally {
            this.useLock.unlock();
        }
        return null;
    }

    protected byte[] getValueFromRocksDb(byte[] keyBytes) throws RocksDBException {
        assert (!this.db.isClosed()) : "RocksDB is already closed.";
        return this.db.get(this.dataHandle, keyBytes);
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        if (entry != null) {
            return entry.getId().getTerm();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean appendEntry(LogEntry entry) {
        if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
            return this.executeBatch(batch -> this.addConfBatch(entry, batch));
        }
        this.useLock.lock();
        try {
            if (this.stopped) {
                LOG.warn("Storage stopped.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            long logIndex = entry.getId().getIndex();
            byte[] valueBytes = this.logEntryEncoder.encode(entry);
            byte[] newValueBytes = this.onDataAppend(logIndex, valueBytes);
            this.db.put(this.dataHandle, this.writeOptions, this.createKey(logIndex), newValueBytes);
            if (newValueBytes != valueBytes) {
                this.doSync();
            }
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to append entry.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    @Override
    public int appendEntries(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return 0;
        }
        int entriesCount = entries.size();
        boolean ret = this.executeBatch(batch -> {
            for (LogEntry entry : entries) {
                if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                    this.addConfBatch(entry, batch);
                    continue;
                }
                this.addDataBatch(entry, batch);
            }
            this.doSync();
        });
        if (ret) {
            return entriesCount;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean appendEntriesToBatch(List<LogEntry> entries) {
        if (entries == null || entries.isEmpty()) {
            return true;
        }
        this.useLock.lock();
        try {
            WriteBatch writeBatch = this.logStorageFactory.getOrCreateThreadLocalWriteBatch();
            for (LogEntry entry : entries) {
                if (entry.getType() == EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
                    this.addConfBatch(entry, writeBatch);
                    continue;
                }
                this.addDataBatch(entry, writeBatch);
            }
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Execute batch failed with rocksdb exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    void commitWriteBatch() {
        WriteBatch writeBatch = this.logStorageFactory.getThreadLocalWriteBatch();
        if (writeBatch == null) {
            return;
        }
        try {
            if (writeBatch.count() > 0) {
                this.db.write(this.writeOptions, writeBatch);
            }
        }
        catch (RocksDBException e) {
            LOG.error("Execute batch failed with rocksdb exception.", (Throwable)e);
        }
        finally {
            this.logStorageFactory.clearThreadLocalWriteBatch(writeBatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        Long lastLogIndex = null;
        this.useLock.lock();
        try {
            this.onTruncateSuffix(lastIndexKept);
            lastLogIndex = this.getLastLogIndex();
            if (lastLogIndex != 0L) {
                assert (lastLogIndex >= lastIndexKept) : String.format("lastLogIndex=%s, lastIndexKept=%s", lastLogIndex, lastIndexKept);
                byte[] beginKey = this.createKey(lastIndexKept + 1L);
                byte[] endKey = this.createKey(lastLogIndex + 1L);
                this.db.deleteRange(this.dataHandle, this.writeOptions, beginKey, endKey);
                this.db.deleteRange(this.confHandle, this.writeOptions, beginKey, endKey);
                boolean bl = true;
                return bl;
            }
            LOG.info("Skip truncateSuffix: [lastIndexKept={}, lastLogIndex={}]", new Object[]{lastIndexKept, lastLogIndex});
        }
        catch (IOException | RocksDBException e) {
            LOG.error("Fail to truncateSuffix: [lastIndexKept={}, lastLogIndex={}]", e, new Object[]{lastIndexKept, lastLogIndex});
        }
        finally {
            this.useLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reset(long nextLogIndex) {
        if (nextLogIndex <= 0L) {
            throw new IllegalArgumentException("Invalid next log index.");
        }
        this.manageLock.lock();
        try {
            LogEntry entry = this.getEntry(nextLogIndex);
            try (WriteBatch writeBatch = new WriteBatch();){
                RocksDbSharedLogStorage.destroyAllEntriesBetween(writeBatch, this.confHandle, this.dataHandle, this.startPrefix, this.endPrefix);
                this.db.write(this.writeOptions, writeBatch);
            }
            this.onReset(nextLogIndex);
            if (this.initAndLoad(null)) {
                if (entry == null) {
                    entry = new LogEntry();
                    entry.setType(EnumOutter.EntryType.ENTRY_TYPE_NO_OP);
                    entry.setId(new LogId(nextLogIndex, 0L));
                    LOG.warn("Entry not found for nextLogIndex {} when reset.", new Object[]{nextLogIndex});
                }
                boolean bl = this.appendEntry(entry);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (RocksDBException e) {
            LOG.error("Fail to reset next log index.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.manageLock.unlock();
        }
    }

    static void destroyAllEntriesBetween(WriteBatch writeBatch, ColumnFamilyHandle confHandle, ColumnFamilyHandle dataHandle, byte[] startPrefix, byte[] endPrefix) throws RocksDBException {
        writeBatch.deleteRange(dataHandle, startPrefix, endPrefix);
        writeBatch.deleteRange(confHandle, startPrefix, endPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        this.useLock.lock();
        try {
            long startIndex = this.getFirstLogIndex();
            boolean ret = this.saveFirstLogIndex(firstIndexKept);
            if (ret) {
                this.setFirstLogIndex(firstIndexKept);
            }
            this.truncatePrefixInBackground(startIndex, firstIndexKept);
            boolean bl = ret;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
    }

    private void addConfBatch(LogEntry entry, WriteBatch batch) throws RocksDBException {
        byte[] ks = this.createKey(entry.getId().getIndex());
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.dataHandle, ks, content);
        batch.put(this.confHandle, ks, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeBatch(WriteBatchTemplate template) {
        this.useLock.lock();
        try (WriteBatch batch = new WriteBatch();){
            if (this.stopped) {
                LOG.warn("Storage stopped.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            template.execute(batch);
            this.db.write(this.writeOptions, batch);
        }
        catch (RocksDBException e) {
            LOG.error("Execute batch failed with rocksdb exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.error("Execute batch failed with io exception.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException e) {
            LOG.error("Execute batch failed with interrupt.", (Throwable)e);
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            this.useLock.unlock();
        }
        return true;
    }

    private void addDataBatch(LogEntry entry, WriteBatch batch) throws RocksDBException {
        long logIndex = entry.getId().getIndex();
        byte[] content = this.logEntryEncoder.encode(entry);
        batch.put(this.dataHandle, this.createKey(logIndex), this.onDataAppend(logIndex, content));
    }

    private void truncatePrefixInBackground(long startIndex, long firstIndexKept) {
        Utils.runInThread(this.executor, () -> {
            this.useLock.lock();
            try {
                if (this.stopped) {
                    return;
                }
                this.onTruncatePrefix(startIndex, firstIndexKept);
                byte[] startKey = this.createKey(startIndex);
                byte[] endKey = this.createKey(firstIndexKept);
                this.db.deleteRange(this.dataHandle, startKey, endKey);
                this.db.deleteRange(this.confHandle, startKey, endKey);
            }
            catch (IOException | RocksDBException e) {
                LOG.error("Fail to truncatePrefix: [startIndex={}, firstIndexKept={}].", e, new Object[]{startIndex, firstIndexKept});
            }
            finally {
                this.useLock.unlock();
            }
        });
    }

    protected void onShutdown() {
        this.endBound.close();
        this.startBound.close();
    }

    private byte[] createKey(byte[] key) {
        return RocksDbSharedLogStorage.createKey(this.startPrefix, key);
    }

    static byte[] createKey(byte[] startPrefix, byte[] key) {
        return ArrayUtils.concat((byte[])startPrefix, (byte[])key);
    }

    private byte[] createKey(long index) {
        byte[] ks = new byte[this.startPrefix.length + 8];
        System.arraycopy(this.startPrefix, 0, ks, 0, this.startPrefix.length);
        LONG_ARRAY_HANDLE.set(ks, this.startPrefix.length, index);
        return ks;
    }

    private void doSync() {
        this.onSync();
    }

    protected byte[] onDataAppend(long logIndex, byte[] value) {
        return value;
    }

    protected void onSync() {
    }

    protected boolean onInitLoaded() {
        return true;
    }

    protected void onReset(long nextLogIndex) {
    }

    protected void onTruncatePrefix(long startIndex, long firstIndexKept) throws RocksDBException, IOException {
    }

    protected void onTruncateSuffix(long lastIndexKept) throws RocksDBException, IOException {
    }

    @Override
    public void describe(Describer.Printer out) {
        this.useLock.lock();
        try {
            if (this.db != null) {
                out.println(this.db.getProperty("rocksdb.stats"));
            }
        }
        catch (RocksDBException e) {
            out.println((Object)e);
        }
        finally {
            this.useLock.unlock();
        }
    }

    static {
        RocksDB.loadLibrary();
        LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.BIG_ENDIAN);
        FIRST_LOG_IDX_KEY = Utils.getBytes("meta/firstLogIndex");
    }

    private static interface WriteBatchTemplate {
        public void execute(WriteBatch var1) throws RocksDBException, IOException, InterruptedException;
    }
}

