/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.raft.jraft.util.Describer;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.timer.HashedWheelTimer;
import org.apache.ignite.raft.jraft.util.timer.Timeout;
import org.apache.ignite.raft.jraft.util.timer.Timer;
import org.apache.ignite.raft.jraft.util.timer.TimerTask;

public abstract class RepeatedTimer
implements Describer {
    public static final IgniteLogger LOG = Loggers.forClass(RepeatedTimer.class);
    private final Lock lock = new ReentrantLock();
    private final Timer timer;
    private Timeout timeout;
    private boolean stopped;
    private volatile boolean running;
    private volatile boolean destroyed;
    private volatile boolean invoking;
    private volatile int timeoutMs;
    private final String name;

    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    public RepeatedTimer(String name, int timeoutMs) {
        this(name, timeoutMs, new HashedWheelTimer((ThreadFactory)IgniteThreadFactory.createWithFixedPrefix((String)name, (boolean)true, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]), 1L, TimeUnit.MILLISECONDS, 2048));
    }

    public RepeatedTimer(String name, int timeoutMs, Timer timer) {
        this.name = name;
        this.timeoutMs = timeoutMs;
        this.stopped = true;
        this.timer = Requires.requireNonNull(timer, "timer");
    }

    protected abstract void onTrigger();

    protected int adjustTimeout(int timeoutMs) {
        return timeoutMs;
    }

    public void run() {
        this.invoking = true;
        try {
            this.onTrigger();
        }
        catch (Throwable t) {
            LOG.error("Run timer failed.", t);
        }
        boolean invokeDestroyed = false;
        this.lock.lock();
        try {
            this.invoking = false;
            if (this.stopped) {
                this.running = false;
                invokeDestroyed = this.destroyed;
            } else {
                this.timeout = null;
                this.schedule();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (invokeDestroyed) {
            this.onDestroy();
        }
    }

    public void runOnceNow() {
        this.lock.lock();
        try {
            if (this.timeout != null && this.timeout.cancel()) {
                this.timeout = null;
                this.run();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void onDestroy() {
        LOG.info("Destroy timer: {}.", new Object[]{this});
    }

    public void start() {
        this.lock.lock();
        try {
            if (this.destroyed) {
                return;
            }
            if (!this.stopped) {
                return;
            }
            this.stopped = false;
            if (this.running) {
                return;
            }
            this.running = true;
            this.schedule();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void restart() {
        this.lock.lock();
        try {
            if (this.destroyed) {
                return;
            }
            this.stopped = false;
            this.running = true;
            this.schedule();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void schedule() {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        TimerTask timerTask = timeout -> {
            try {
                this.run();
            }
            catch (Throwable t) {
                LOG.error("Run timer task failed, taskName={}.", t, new Object[]{this.name});
            }
        };
        this.timeout = this.timer.newTimeout(timerTask, this.adjustTimeout(this.timeoutMs), TimeUnit.MILLISECONDS);
    }

    public void reset(int timeoutMs) {
        this.lock.lock();
        this.timeoutMs = timeoutMs;
        try {
            if (this.stopped) {
                return;
            }
            if (this.running) {
                this.schedule();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.lock.lock();
        try {
            this.reset(this.timeoutMs);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        boolean invokeDestroyed = false;
        this.lock.lock();
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            if (!this.running) {
                invokeDestroyed = true;
            }
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            if (this.timeout != null) {
                if (this.timeout.cancel()) {
                    invokeDestroyed = true;
                    this.running = false;
                }
                this.timeout = null;
            }
        }
        finally {
            this.lock.unlock();
            this.timer.stop();
            if (invokeDestroyed) {
                this.onDestroy();
            }
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            if (this.timeout != null) {
                this.timeout.cancel();
                this.running = false;
                this.timeout = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void describe(Describer.Printer out) {
        String _describeString;
        this.lock.lock();
        try {
            _describeString = this.toString();
        }
        finally {
            this.lock.unlock();
        }
        out.print("  ").println(_describeString);
    }

    public String toString() {
        return "RepeatedTimer{timeout=" + this.timeout + ", stopped=" + this.stopped + ", running=" + this.running + ", destroyed=" + this.destroyed + ", invoking=" + this.invoking + ", timeoutMs=" + this.timeoutMs + ", name='" + this.name + "'}";
    }
}

