/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.RequestVoteRequestImpl;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class RequestVoteRequestSerializer
implements MessageSerializer<RpcRequests.RequestVoteRequest> {
    public static final RequestVoteRequestSerializer INSTANCE = new RequestVoteRequestSerializer();

    private RequestVoteRequestSerializer() {
    }

    public boolean writeMessage(RpcRequests.RequestVoteRequest msg, MessageWriter writer) throws MessageMappingException {
        RequestVoteRequestImpl message = (RequestVoteRequestImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.requestVoteRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("lastLogIndex", message.lastLogIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeLong("lastLogTerm", message.lastLogTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("peerId", message.peerId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeBoolean("preVote", message.preVote());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeString("serverId", message.serverId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeLong("term", message.term());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

