/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.RequestVoteRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RequestVoteRequestSerializer;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class RequestVoteRequestImpl
implements RpcRequests.RequestVoteRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3006;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final long lastLogIndex;
    @IgniteToStringInclude
    private final long lastLogTerm;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final boolean preVote;
    @IgniteToStringInclude
    private final String serverId;
    @IgniteToStringInclude
    private final long term;

    private RequestVoteRequestImpl(String groupId, long lastLogIndex, long lastLogTerm, String peerId, boolean preVote, String serverId, long term) {
        this.groupId = groupId;
        this.lastLogIndex = lastLogIndex;
        this.lastLogTerm = lastLogTerm;
        this.peerId = peerId;
        this.preVote = preVote;
        this.serverId = serverId;
        this.term = term;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    @Override
    public long lastLogTerm() {
        return this.lastLogTerm;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public boolean preVote() {
        return this.preVote;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public long term() {
        return this.term;
    }

    public MessageSerializer serializer() {
        return RequestVoteRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(RequestVoteRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3006;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RequestVoteRequestImpl otherMessage = (RequestVoteRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId) && this.lastLogIndex == otherMessage.lastLogIndex && this.lastLogTerm == otherMessage.lastLogTerm && this.preVote == otherMessage.preVote && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.lastLogIndex, this.lastLogTerm, this.preVote, this.term, this.groupId, this.peerId, this.serverId);
        return result;
    }

    public RequestVoteRequestImpl clone() {
        try {
            return (RequestVoteRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static RequestVoteRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements RequestVoteRequestBuilder {
        private String groupId;
        private long lastLogIndex;
        private long lastLogTerm;
        private String peerId;
        private boolean preVote;
        private String serverId;
        private long term;

        private Builder() {
        }

        @Override
        public RequestVoteRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public RequestVoteRequestBuilder lastLogIndex(long lastLogIndex) {
            this.lastLogIndex = lastLogIndex;
            return this;
        }

        @Override
        public RequestVoteRequestBuilder lastLogTerm(long lastLogTerm) {
            this.lastLogTerm = lastLogTerm;
            return this;
        }

        @Override
        public RequestVoteRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public RequestVoteRequestBuilder preVote(boolean preVote) {
            this.preVote = preVote;
            return this;
        }

        @Override
        public RequestVoteRequestBuilder serverId(String serverId) {
            Objects.requireNonNull(serverId, "serverId is not marked @Nullable");
            this.serverId = serverId;
            return this;
        }

        @Override
        public RequestVoteRequestBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public long lastLogIndex() {
            return this.lastLogIndex;
        }

        @Override
        public long lastLogTerm() {
            return this.lastLogTerm;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public boolean preVote() {
            return this.preVote;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public RpcRequests.RequestVoteRequest build() {
            return new RequestVoteRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), this.lastLogIndex, this.lastLogTerm, Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"), this.preVote, Objects.requireNonNull(this.serverId, "serverId is not marked @Nullable"), this.term);
        }

        @Override
        public RpcRequests.RequestVoteRequest buildDeserialized() {
            return new RequestVoteRequestImpl(this.groupId, this.lastLogIndex, this.lastLogTerm, this.peerId, this.preVote, this.serverId, this.term);
        }
    }
}

