/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.rpc.InstallSnapshotRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.InstallSnapshotRequestSerializer;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class InstallSnapshotRequestImpl
implements RpcRequests.InstallSnapshotRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3002;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final RaftOutter.SnapshotMeta meta;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final String serverId;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private final String uri;

    private InstallSnapshotRequestImpl(String groupId, RaftOutter.SnapshotMeta meta, String peerId, String serverId, long term, String uri) {
        this.groupId = groupId;
        this.meta = meta;
        this.peerId = peerId;
        this.serverId = serverId;
        this.term = term;
        this.uri = uri;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public RaftOutter.SnapshotMeta meta() {
        return this.meta;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public MessageSerializer serializer() {
        return InstallSnapshotRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(InstallSnapshotRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3002;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InstallSnapshotRequestImpl otherMessage = (InstallSnapshotRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.meta, otherMessage.meta) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId) && Objects.equals(this.uri, otherMessage.uri) && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.term, this.groupId, this.meta, this.peerId, this.serverId, this.uri);
        return result;
    }

    public InstallSnapshotRequestImpl clone() {
        try {
            return (InstallSnapshotRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InstallSnapshotRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.meta != null) {
            this.meta.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.meta != null) {
            this.meta.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements InstallSnapshotRequestBuilder {
        private String groupId;
        private RaftOutter.SnapshotMeta meta;
        private String peerId;
        private String serverId;
        private long term;
        private String uri;

        private Builder() {
        }

        @Override
        public InstallSnapshotRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder meta(RaftOutter.SnapshotMeta meta) {
            Objects.requireNonNull(meta, "meta is not marked @Nullable");
            this.meta = meta;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder serverId(String serverId) {
            Objects.requireNonNull(serverId, "serverId is not marked @Nullable");
            this.serverId = serverId;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder uri(String uri) {
            Objects.requireNonNull(uri, "uri is not marked @Nullable");
            this.uri = uri;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public RaftOutter.SnapshotMeta meta() {
            return this.meta;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public RpcRequests.InstallSnapshotRequest build() {
            return new InstallSnapshotRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.meta, "meta is not marked @Nullable"), Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"), Objects.requireNonNull(this.serverId, "serverId is not marked @Nullable"), this.term, Objects.requireNonNull(this.uri, "uri is not marked @Nullable"));
        }

        @Override
        public RpcRequests.InstallSnapshotRequest buildDeserialized() {
            return new InstallSnapshotRequestImpl(this.groupId, this.meta, this.peerId, this.serverId, this.term, this.uri);
        }
    }
}

