/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.util;

import java.nio.file.Path;
import java.util.function.BiFunction;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.DefaultLogStorageFactory;
import org.apache.ignite.internal.raft.storage.logit.LogitLogStorageFactory;
import org.apache.ignite.raft.jraft.storage.logit.option.StoreOptions;
import org.jetbrains.annotations.TestOnly;

public class SharedLogStorageFactoryUtils {
    public static final String LOGIT_STORAGE_ENABLED_PROPERTY = "LOGIT_STORAGE_ENABLED";
    private static final boolean LOGIT_STORAGE_ENABLED_PROPERTY_DEFAULT = false;

    @TestOnly
    public static LogStorageFactory create(String nodeName, Path logStoragePath) {
        return SharedLogStorageFactoryUtils.create(nodeName, logStoragePath, DefaultLogStorageFactory::new);
    }

    public static LogStorageFactory create(String nodeName, Path logStoragePath, BiFunction<String, Path, LogStorageFactory> baseFactory) {
        return IgniteSystemProperties.getBoolean((String)LOGIT_STORAGE_ENABLED_PROPERTY, (boolean)false) ? new LogitLogStorageFactory(nodeName, new StoreOptions(), logStoragePath) : baseFactory.apply(nodeName, logStoragePath);
    }
}

