/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageException;
import org.apache.ignite.internal.raft.storage.impl.MetadataMigration;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorage;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorageUtils;
import org.apache.ignite.internal.rocksdb.LoggingRocksDbFlushListener;
import org.apache.ignite.internal.rocksdb.RocksUtils;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.Platform;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.Priority;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class DefaultLogStorageFactory
implements LogStorageFactory {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultLogStorageFactory.class);
    static final byte[] FINISHED_META_MIGRATION_META_KEY = new byte[]{0};
    static final byte[] STORAGE_CREATED_META_PREFIX = new byte[]{1};
    private final String factoryName;
    private final String nodeName;
    private final Path logPath;
    private volatile ExecutorService executorService;
    private RocksDB db;
    private DBOptions dbOptions;
    private WriteOptions writeOptions;
    private ColumnFamilyHandle metaHandle;
    private ColumnFamilyHandle confHandle;
    private ColumnFamilyHandle dataHandle;
    private ColumnFamilyOptions cfOption;
    protected List<AbstractNativeReference> additionalDbClosables = new ArrayList<AbstractNativeReference>();
    private AbstractEventListener flushListener;
    private final boolean fsync;
    private final ThreadLocal<WriteBatch> threadLocalWriteBatch = new ThreadLocal();

    @TestOnly
    public DefaultLogStorageFactory(Path path) {
        this("test", "test", path, true);
    }

    @TestOnly
    public DefaultLogStorageFactory(String nodeName, Path path) {
        this("test", "test", path, true);
    }

    public DefaultLogStorageFactory(String factoryName, String nodeName, Path logPath, boolean fsync) {
        this.factoryName = factoryName;
        this.logPath = logPath;
        this.fsync = fsync;
        this.nodeName = nodeName;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)IgniteThreadFactory.create((String)this.nodeName, (String)"raft-shared-log-storage-pool", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        try {
            this.start();
            return CompletableFutures.nullCompletedFuture();
        }
        catch (Exception ex) {
            return CompletableFuture.failedFuture(ex);
        }
    }

    private void start() throws Exception {
        try {
            Files.createDirectories(this.logPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory: " + this.logPath, e);
        }
        ArrayList columnFamilyHandles = new ArrayList();
        this.dbOptions = this.createDbOptions();
        this.writeOptions = new WriteOptions().setSync(this.dbOptions.useFsync());
        this.cfOption = DefaultLogStorageFactory.createColumnFamilyOptions();
        this.flushListener = new LoggingRocksDbFlushListener(this.factoryName, this.nodeName);
        List<ColumnFamilyDescriptor> columnFamilyDescriptors = List.of(new ColumnFamilyDescriptor("Meta".getBytes(StandardCharsets.UTF_8), this.cfOption), new ColumnFamilyDescriptor("Configuration".getBytes(StandardCharsets.UTF_8), this.cfOption), new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, this.cfOption));
        try {
            this.dbOptions.setListeners(List.of(this.flushListener));
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.logPath.toString(), columnFamilyDescriptors, columnFamilyHandles);
            Env env = this.db.getEnv();
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.HIGH);
            env.setBackgroundThreads(Runtime.getRuntime().availableProcessors(), Priority.LOW);
            assert (columnFamilyHandles.size() == 3);
            this.metaHandle = (ColumnFamilyHandle)columnFamilyHandles.get(0);
            this.confHandle = (ColumnFamilyHandle)columnFamilyHandles.get(1);
            this.dataHandle = (ColumnFamilyHandle)columnFamilyHandles.get(2);
            MetadataMigration metadataMigration = this.metadataMigration();
            metadataMigration.migrateIfNeeded();
        }
        catch (Exception e) {
            this.closeRocksResources();
            throw e;
        }
    }

    MetadataMigration metadataMigration() {
        return new MetadataMigration(this.db, this.writeOptions, this.metaHandle, this.confHandle, this.dataHandle);
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        ExecutorService localExecutor = this.executorService;
        if (localExecutor != null) {
            ExecutorServiceHelper.shutdownAndAwaitTermination(localExecutor);
        }
        try {
            this.closeRocksResources();
        }
        catch (RuntimeException ex) {
            return CompletableFuture.failedFuture(ex);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private void closeRocksResources() {
        ArrayList<Object> closables = new ArrayList<Object>();
        closables.add(this.confHandle);
        closables.add(this.dataHandle);
        closables.add(this.db);
        closables.add(this.dbOptions);
        closables.addAll(this.additionalDbClosables);
        closables.add(this.cfOption);
        closables.add(this.flushListener);
        closables.add(this.writeOptions);
        RocksUtils.closeAll(closables);
    }

    @Override
    public LogStorage createLogStorage(String raftNodeStorageId, RaftOptions raftOptions) {
        ExecutorService localExecutor = this.executorService;
        assert (localExecutor != null);
        return new RocksDbSharedLogStorage(this, this.db, this.metaHandle, this.confHandle, this.dataHandle, raftNodeStorageId, this.writeOptions, localExecutor);
    }

    @Override
    public void destroyLogStorage(String uri) {
        try (WriteBatch writeBatch = new WriteBatch();){
            RocksDbSharedLogStorage.destroyAllEntriesBetween(writeBatch, this.confHandle, this.dataHandle, RocksDbSharedLogStorageUtils.raftNodeStorageStartPrefix(uri), RocksDbSharedLogStorageUtils.raftNodeStorageEndPrefix(uri));
            writeBatch.delete(this.metaHandle, RocksDbSharedLogStorage.storageCreatedKey(uri));
            this.db.write(this.writeOptions, writeBatch);
        }
        catch (RocksDBException e) {
            throw new LogStorageException("Fail to destroy the log storage for " + uri, e);
        }
    }

    public void sync() throws RocksDBException {
        if (!this.dbOptions.useFsync()) {
            this.db.syncWal();
        }
    }

    WriteBatch getOrCreateThreadLocalWriteBatch() {
        WriteBatch writeBatch = this.threadLocalWriteBatch.get();
        if (writeBatch == null) {
            writeBatch = new WriteBatch();
            this.threadLocalWriteBatch.set(writeBatch);
        }
        return writeBatch;
    }

    @Nullable
    WriteBatch getThreadLocalWriteBatch() {
        return this.threadLocalWriteBatch.get();
    }

    void clearThreadLocalWriteBatch(WriteBatch writeBatch) {
        writeBatch.close();
        this.threadLocalWriteBatch.remove();
    }

    protected DBOptions createDbOptions() {
        return new DBOptions().setMaxBackgroundJobs(Runtime.getRuntime().availableProcessors() * 2).setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setUseFsync(this.fsync);
    }

    @TestOnly
    @Nullable
    public DBOptions dbOptions() {
        return this.dbOptions;
    }

    @TestOnly
    @Nullable
    public WriteOptions writeOptions() {
        return this.writeOptions;
    }

    private static ColumnFamilyOptions createColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(5);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(50);
        opts.setLevel0SlowdownWritesTrigger(100);
        opts.setLevel0StopWritesTrigger(200);
        opts.setMaxBytesForLevelBase(0xC8000000L);
        opts.setTargetFileSizeBase(0x14000000L);
        if (!Platform.isWindows()) {
            opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        }
        return opts;
    }

    @Override
    public Set<String> raftNodeStorageIdsOnDisk() {
        HashSet<String> groupIdsForStorage = new HashSet<String>();
        try (Slice upperBoundSlice = new Slice(RocksUtils.incrementPrefix((byte[])STORAGE_CREATED_META_PREFIX));
             ReadOptions readOptions = new ReadOptions().setIterateUpperBound((AbstractSlice)upperBoundSlice);
             RocksIterator iterator = this.db.newIterator(this.metaHandle, readOptions);){
            iterator.seek(STORAGE_CREATED_META_PREFIX);
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                String idForStorage = new String(key, STORAGE_CREATED_META_PREFIX.length, key.length - STORAGE_CREATED_META_PREFIX.length, StandardCharsets.UTF_8);
                groupIdsForStorage.add(idForStorage);
                iterator.next();
            }
            iterator.status();
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Cannot get group storage IDs", (Throwable)e);
        }
        return Collections.unmodifiableSet(groupIdsForStorage);
    }

    @TestOnly
    RocksDB db() {
        return this.db;
    }

    @TestOnly
    ColumnFamilyHandle metaColumnFamilyHandle() {
        return this.metaHandle;
    }

    @TestOnly
    ColumnFamilyHandle confColumnFamilyHandle() {
        return this.confHandle;
    }

    @TestOnly
    ColumnFamilyHandle dataColumnFamilyHandle() {
        return this.dataHandle;
    }
}

