/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.io.IOException;
import java.util.List;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFileManager;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite.raft.jraft.option.LogStorageOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.jetbrains.annotations.Nullable;

class SegstoreLogStorage
implements LogStorage {
    private final long groupId;
    private final SegmentFileManager segmentFileManager;
    private volatile LogEntryEncoder logEntryEncoder;
    private volatile LogEntryDecoder logEntryDecoder;

    SegstoreLogStorage(long groupId, SegmentFileManager segmentFileManager) {
        if (groupId <= 0L) {
            throw new IllegalArgumentException("groupId must be greater than 0: " + groupId);
        }
        this.groupId = groupId;
        this.segmentFileManager = segmentFileManager;
    }

    @Override
    public boolean init(LogStorageOptions opts) {
        this.logEntryEncoder = opts.getLogEntryCodecFactory().encoder();
        this.logEntryDecoder = opts.getLogEntryCodecFactory().decoder();
        return true;
    }

    @Override
    public boolean appendEntry(LogEntry entry) {
        try {
            this.segmentFileManager.appendEntry(this.groupId, entry, this.logEntryEncoder);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
        return true;
    }

    @Override
    public int appendEntries(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            this.appendEntry(entry);
        }
        return entries.size();
    }

    @Override
    public long getFirstLogIndex() {
        long firstLogIndex = this.segmentFileManager.firstLogIndexInclusive(this.groupId);
        return firstLogIndex >= 0L ? firstLogIndex : 1L;
    }

    @Override
    public long getLastLogIndex() {
        long lastLogIndex = this.segmentFileManager.lastLogIndexExclusive(this.groupId);
        return Math.max(lastLogIndex - 1L, 0L);
    }

    @Override
    @Nullable
    public LogEntry getEntry(long index) {
        try {
            return this.segmentFileManager.getEntry(this.groupId, index, this.logEntryDecoder);
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    @Override
    public long getTerm(long index) {
        LogEntry entry = this.getEntry(index);
        return entry == null ? 0L : entry.getId().getTerm();
    }

    @Override
    public boolean truncatePrefix(long firstIndexKept) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean truncateSuffix(long lastIndexKept) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean reset(long nextLogIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
    }
}

