/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.FastCrc;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;

class SegmentPayload {
    static final int GROUP_ID_SIZE_BYTES = 8;
    static final int LENGTH_SIZE_BYTES = 4;
    static final int HASH_SIZE = 4;

    SegmentPayload() {
    }

    static void writeTo(ByteBuffer buffer, long groupId, int entrySize, LogEntry logEntry, LogEntryEncoder logEntryEncoder) {
        int originalPos = buffer.position();
        buffer.putLong(groupId).putInt(entrySize);
        logEntryEncoder.encode(buffer, logEntry);
        int dataSize = buffer.position() - originalPos;
        buffer.position(originalPos);
        int crc = FastCrc.calcCrc((ByteBuffer)buffer, (int)dataSize);
        buffer.putInt(crc);
    }

    static LogEntry readFrom(ByteBuffer buffer, LogEntryDecoder logEntryDecoder) {
        int entrySize = buffer.getInt(buffer.position() + 8);
        SegmentPayload.verifyCrc(buffer, entrySize);
        buffer.position(buffer.position() + 8 + 4);
        byte[] entryBytes = new byte[entrySize];
        buffer.get(entryBytes);
        buffer.position(buffer.position() + 4);
        return logEntryDecoder.decode(entryBytes);
    }

    private static void verifyCrc(ByteBuffer buffer, int entrySize) {
        int position = buffer.position();
        int dataSize = SegmentPayload.size(entrySize) - 4;
        int expectedCrc = buffer.getInt(position + dataSize);
        int actualCrc = FastCrc.calcCrc((ByteBuffer)buffer, (int)dataSize);
        buffer.position(position);
        if (expectedCrc != actualCrc) {
            throw new IllegalStateException("CRC mismatch, expected: " + expectedCrc + ", actual: " + actualCrc);
        }
    }

    static int size(int entrySize) {
        return SegmentPayload.overheadSize() + entrySize;
    }

    static int overheadSize() {
        return 16;
    }
}

