/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileManager;
import org.apache.ignite.internal.raft.storage.segstore.IndexMemTable;
import org.apache.ignite.internal.raft.storage.segstore.RaftLogCheckpointer;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFile;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFilePointer;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFileWithMemtable;
import org.apache.ignite.internal.raft.storage.segstore.SegmentInfo;
import org.apache.ignite.internal.raft.storage.segstore.SegmentPayload;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite.raft.jraft.entity.codec.LogEntryEncoder;
import org.jetbrains.annotations.Nullable;

class SegmentFileManager
implements ManuallyCloseable {
    private static final int ROLLOVER_WAIT_TIMEOUT_MS = 30000;
    private static final int MAGIC_NUMBER = -17958194;
    private static final int FORMAT_VERSION = 1;
    private static final String SEGMENT_FILE_NAME_FORMAT = "segment-%010d-%010d.bin";
    static final byte[] HEADER_RECORD = ByteBuffer.allocate(8).order(SegmentFile.BYTE_ORDER).putInt(-17958194).putInt(1).array();
    static final byte[] SWITCH_SEGMENT_RECORD = new byte[8];
    private final Path segmentFilesDir;
    private final long fileSize;
    private final int stripes;
    private final AtomicReference<SegmentFileWithMemtable> currentSegmentFile = new AtomicReference();
    private final RaftLogCheckpointer checkpointer;
    private final IndexFileManager indexFileManager;
    private final Object rolloverLock = new Object();
    private int curSegmentFileOrdinal;
    private boolean isStopped;

    SegmentFileManager(String nodeName, Path baseDir, long fileSize, int stripes, FailureProcessor failureProcessor) throws IOException {
        if (fileSize <= (long)HEADER_RECORD.length) {
            throw new IllegalArgumentException("File size must be greater than the header size: " + fileSize);
        }
        this.segmentFilesDir = baseDir.resolve("segments");
        Files.createDirectories(this.segmentFilesDir, new FileAttribute[0]);
        this.fileSize = fileSize;
        this.stripes = stripes;
        this.indexFileManager = new IndexFileManager(baseDir);
        this.checkpointer = new RaftLogCheckpointer(nodeName, this.indexFileManager, failureProcessor);
    }

    void start() throws IOException {
        this.checkpointer.start();
        this.currentSegmentFile.set(this.allocateNewSegmentFile(0));
    }

    Path segmentFilesDir() {
        return this.segmentFilesDir;
    }

    Path indexFilesDir() {
        return this.indexFileManager.indexFilesDir();
    }

    private SegmentFileWithMemtable allocateNewSegmentFile(int fileOrdinal) throws IOException {
        Path path = this.segmentFilesDir.resolve(SegmentFileManager.segmentFileName(fileOrdinal, 0));
        SegmentFile segmentFile = SegmentFile.createNew(path, this.fileSize);
        SegmentFileManager.writeHeader(segmentFile);
        return new SegmentFileWithMemtable(segmentFile, new IndexMemTable(this.stripes), false);
    }

    private static String segmentFileName(int fileOrdinal, int generation) {
        return String.format(SEGMENT_FILE_NAME_FORMAT, fileOrdinal, generation);
    }

    private static SegmentFileWithMemtable convertToReadOnly(SegmentFileWithMemtable segmentFile) {
        return new SegmentFileWithMemtable(segmentFile.segmentFile(), segmentFile.memtable(), true);
    }

    void appendEntry(long groupId, LogEntry entry, LogEntryEncoder encoder) throws IOException {
        int entrySize = encoder.size(entry);
        if ((long)entrySize > this.maxEntrySize()) {
            throw new IllegalArgumentException(String.format("Entry size is too big (%d bytes), maximum allowed entry size: %d bytes.", entrySize, this.maxEntrySize()));
        }
        int payloadSize = SegmentPayload.size(entrySize);
        while (true) {
            SegmentFileWithMemtable segmentFileWithMemtable = this.currentSegmentFile();
            try (SegmentFile.WriteBuffer writeBuffer = segmentFileWithMemtable.segmentFile().reserve(payloadSize);){
                if (writeBuffer != null) {
                    int segmentOffset = writeBuffer.buffer().position();
                    SegmentPayload.writeTo(writeBuffer.buffer(), groupId, entrySize, entry, encoder);
                    segmentFileWithMemtable.memtable().appendSegmentFileOffset(groupId, entry.getId().getIndex(), segmentOffset);
                    return;
                }
            }
            this.initiateRollover(segmentFileWithMemtable);
        }
    }

    @Nullable
    LogEntry getEntry(long groupId, long logIndex, LogEntryDecoder decoder) throws IOException {
        ByteBuffer entryBuffer = this.getEntry(groupId, logIndex);
        return entryBuffer == null ? null : SegmentPayload.readFrom(entryBuffer, decoder);
    }

    @Nullable
    private ByteBuffer getEntry(long groupId, long logIndex) throws IOException {
        ByteBuffer bufferFromCurrentSegmentFile = this.readFromCurrentSegmentFile(groupId, logIndex);
        if (bufferFromCurrentSegmentFile != null) {
            return bufferFromCurrentSegmentFile;
        }
        ByteBuffer bufferFromCheckpointQueue = this.checkpointer.findSegmentPayloadInQueue(groupId, logIndex);
        if (bufferFromCheckpointQueue != null) {
            return bufferFromCheckpointQueue;
        }
        return this.readFromOtherSegmentFiles(groupId, logIndex);
    }

    long firstLogIndexInclusive(long groupId) {
        long logIndexFromMemtable = this.firstLogIndexFromMemtable(groupId);
        long logIndexFromCheckpointQueue = this.checkpointer.firstLogIndexInclusive(groupId);
        long logIndexFromIndexFiles = this.indexFileManager.firstLogIndexInclusive(groupId);
        if (logIndexFromIndexFiles >= 0L) {
            return logIndexFromIndexFiles;
        }
        if (logIndexFromCheckpointQueue >= 0L) {
            return logIndexFromCheckpointQueue;
        }
        return logIndexFromMemtable;
    }

    private long firstLogIndexFromMemtable(long groupId) {
        SegmentFileWithMemtable currentSegmentFile = this.currentSegmentFile.get();
        SegmentInfo segmentInfo = currentSegmentFile.memtable().segmentInfo(groupId);
        return segmentInfo == null ? -1L : segmentInfo.firstLogIndexInclusive();
    }

    long lastLogIndexExclusive(long groupId) {
        long logIndexFromMemtable = this.lastLogIndexFromMemtable(groupId);
        if (logIndexFromMemtable >= 0L) {
            return logIndexFromMemtable;
        }
        long logIndexFromCheckpointQueue = this.checkpointer.lastLogIndexExclusive(groupId);
        if (logIndexFromCheckpointQueue >= 0L) {
            return logIndexFromCheckpointQueue;
        }
        return this.indexFileManager.lastLogIndexExclusive(groupId);
    }

    private long lastLogIndexFromMemtable(long groupId) {
        SegmentFileWithMemtable currentSegmentFile = this.currentSegmentFile.get();
        SegmentInfo segmentInfo = currentSegmentFile.memtable().segmentInfo(groupId);
        return segmentInfo == null ? -1L : segmentInfo.lastLogIndexExclusive();
    }

    private SegmentFileWithMemtable currentSegmentFile() {
        SegmentFileWithMemtable segmentFile = this.currentSegmentFile.get();
        if (!segmentFile.readOnly()) {
            return segmentFile;
        }
        try {
            Object object = this.rolloverLock;
            synchronized (object) {
                while (true) {
                    if (this.isStopped) {
                        throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR);
                    }
                    segmentFile = this.currentSegmentFile.get();
                    if (!segmentFile.readOnly()) {
                        return segmentFile;
                    }
                    this.rolloverLock.wait(30000L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Interrupted while waiting for rollover.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateRollover(SegmentFileWithMemtable observedSegmentFile) throws IOException {
        if (!this.currentSegmentFile.compareAndSet(observedSegmentFile, SegmentFileManager.convertToReadOnly(observedSegmentFile))) {
            return;
        }
        this.checkpointer.onRollover(observedSegmentFile.segmentFile(), observedSegmentFile.memtable().transitionToReadMode());
        Object object = this.rolloverLock;
        synchronized (object) {
            if (this.isStopped) {
                throw new IgniteInternalException(ErrorGroups.Common.NODE_STOPPING_ERR);
            }
            this.currentSegmentFile.set(this.allocateNewSegmentFile(++this.curSegmentFileOrdinal));
            this.rolloverLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.rolloverLock;
        synchronized (object) {
            if (this.isStopped) {
                return;
            }
            this.isStopped = true;
            SegmentFileWithMemtable segmentFile = this.currentSegmentFile.get();
            segmentFile.segmentFile().close();
            this.rolloverLock.notifyAll();
        }
        this.checkpointer.stop();
    }

    private static void writeHeader(SegmentFile segmentFile) {
        try (SegmentFile.WriteBuffer writeBuffer = segmentFile.reserve(HEADER_RECORD.length);){
            assert (writeBuffer != null);
            writeBuffer.buffer().put(HEADER_RECORD);
        }
    }

    private long maxEntrySize() {
        return this.fileSize - (long)HEADER_RECORD.length - (long)SegmentPayload.overheadSize();
    }

    @Nullable
    private ByteBuffer readFromCurrentSegmentFile(long groupId, long logIndex) {
        int segmentPayloadOffset;
        SegmentFileWithMemtable currentSegmentFile = this.currentSegmentFile.get();
        SegmentInfo segmentInfo = currentSegmentFile.memtable().segmentInfo(groupId);
        int n = segmentPayloadOffset = segmentInfo == null ? 0 : segmentInfo.getOffset(logIndex);
        if (segmentPayloadOffset == 0) {
            return null;
        }
        return currentSegmentFile.segmentFile().buffer().position(segmentPayloadOffset);
    }

    @Nullable
    private ByteBuffer readFromOtherSegmentFiles(long groupId, long logIndex) throws IOException {
        SegmentFilePointer segmentFilePointer = this.indexFileManager.getSegmentFilePointer(groupId, logIndex);
        if (segmentFilePointer == null) {
            return null;
        }
        Path path = this.segmentFilesDir.resolve(SegmentFileManager.segmentFileName(segmentFilePointer.fileOrdinal(), 0));
        SegmentFile segmentFile = SegmentFile.openExisting(path);
        return segmentFile.buffer().position(segmentFilePointer.payloadOffset());
    }
}

