/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Iterator;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.raft.storage.segstore.CheckpointQueue;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileManager;
import org.apache.ignite.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFile;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFileManager;
import org.apache.ignite.internal.raft.storage.segstore.SegmentInfo;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

class RaftLogCheckpointer {
    static final int MAX_QUEUE_SIZE = 10;
    private final CheckpointQueue queue = new CheckpointQueue(10);
    private final Thread checkpointThread;
    private final IndexFileManager indexFileManager;
    private final FailureProcessor failureProcessor;

    RaftLogCheckpointer(String nodeName, IndexFileManager indexFileManager, FailureProcessor failureProcessor) {
        this.indexFileManager = indexFileManager;
        this.failureProcessor = failureProcessor;
        this.checkpointThread = new IgniteThread(nodeName, "segstore-checkpoint", (Runnable)new CheckpointTask(), new ThreadOperation[0]);
    }

    void start() {
        this.checkpointThread.start();
    }

    void stop() throws Exception {
        IgniteUtils.closeAllManually((ManuallyCloseable[])new ManuallyCloseable[]{this::stopCheckpointThread, this.queue});
    }

    private void stopCheckpointThread() {
        this.checkpointThread.interrupt();
        try {
            this.checkpointThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Marshalling.COMMON_ERR, "Interrupted while waiting for the checkpoint thread to finish.", (Throwable)e);
        }
    }

    void onRollover(SegmentFile segmentFile, ReadModeIndexMemTable indexMemTable) {
        try {
            this.queue.add(segmentFile, indexMemTable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Marshalling.COMMON_ERR, "Interrupted while adding an entry to the checkpoint queue.", (Throwable)e);
        }
    }

    @Nullable
    ByteBuffer findSegmentPayloadInQueue(long groupId, long logIndex) {
        Iterator<CheckpointQueue.Entry> it = this.queue.tailIterator();
        while (it.hasNext()) {
            CheckpointQueue.Entry e = it.next();
            SegmentInfo segmentInfo = e.memTable().segmentInfo(groupId);
            int segmentPayloadOffset = segmentInfo == null ? 0 : segmentInfo.getOffset(logIndex);
            if (segmentPayloadOffset == 0) continue;
            return e.segmentFile().buffer().position(segmentPayloadOffset);
        }
        return null;
    }

    long firstLogIndexInclusive(long groupId) {
        Iterator<CheckpointQueue.Entry> it = this.queue.tailIterator();
        long firstIndex = -1L;
        while (it.hasNext()) {
            SegmentInfo segmentInfo = it.next().memTable().segmentInfo(groupId);
            if (segmentInfo == null) continue;
            firstIndex = segmentInfo.firstLogIndexInclusive();
        }
        return firstIndex;
    }

    long lastLogIndexExclusive(long groupId) {
        Iterator<CheckpointQueue.Entry> it = this.queue.tailIterator();
        while (it.hasNext()) {
            SegmentInfo segmentInfo = it.next().memTable().segmentInfo(groupId);
            if (segmentInfo == null) continue;
            return segmentInfo.lastLogIndexExclusive();
        }
        return -1L;
    }

    private class CheckpointTask
    implements Runnable {
        private CheckpointTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CheckpointQueue.Entry entry = RaftLogCheckpointer.this.queue.peekHead();
                        SegmentFile segmentFile = entry.segmentFile();
                        segmentFile.closeForRollover(SegmentFileManager.SWITCH_SEGMENT_RECORD);
                        segmentFile.sync();
                        RaftLogCheckpointer.this.indexFileManager.saveIndexMemtable(entry.memTable());
                        RaftLogCheckpointer.this.queue.removeHead();
                    }
                }
                catch (InterruptedException | ClosedByInterruptException e) {
                    return;
                }
                catch (IOException e) {
                    RaftLogCheckpointer.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
                    continue;
                }
                break;
            }
        }
    }
}

