/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.TimeoutNowRequestBuilder;

class TimeoutNowRequestDeserializer
implements MessageDeserializer<RpcRequests.TimeoutNowRequest> {
    private final TimeoutNowRequestBuilder msg;

    TimeoutNowRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.timeoutNowRequest();
    }

    public Class<RpcRequests.TimeoutNowRequest> klass() {
        return RpcRequests.TimeoutNowRequest.class;
    }

    public RpcRequests.TimeoutNowRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.timeoutNowRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("peerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.peerId(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                String tmp = reader.readString("serverId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.serverId(tmp);
                }
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 4: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.TimeoutNowRequest.class);
    }
}

