/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.raft.ReadCommand;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.ReadActionRequest;
import org.apache.ignite.raft.jraft.rpc.ReadActionRequestBuilder;

class ReadActionRequestDeserializer
implements MessageDeserializer<ReadActionRequest> {
    private final ReadActionRequestBuilder msg;

    ReadActionRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readActionRequest();
    }

    public Class<ReadActionRequest> klass() {
        return ReadActionRequest.class;
    }

    public ReadActionRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.readActionRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = (ReadCommand)reader.readMessage("command");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.command((ReadCommand)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId(tmp);
                }
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("readOnlySafe");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readOnlySafe(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadActionRequest.class);
    }
}

