/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.LeaderChangeNotificationBuilder;

class LeaderChangeNotificationDeserializer
implements MessageDeserializer<CliRequests.LeaderChangeNotification> {
    private final LeaderChangeNotificationBuilder msg;

    LeaderChangeNotificationDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.leaderChangeNotification();
    }

    public Class<CliRequests.LeaderChangeNotification> klass() {
        return CliRequests.LeaderChangeNotification.class;
    }

    public CliRequests.LeaderChangeNotification getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.leaderChangeNotification());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("groupIdByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupIdByteArray(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.LeaderChangeNotification.class);
    }
}

