/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.raft.storage.segstore.CheckpointQueue;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileManager;
import org.apache.ignite.internal.raft.storage.segstore.ReadModeIndexMemTable;
import org.apache.ignite.internal.raft.storage.segstore.SegmentFile;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.lang.ErrorGroups;

class RaftLogCheckpointer {
    static final int MEM_TABLE_QUEUE_SIZE = 10;
    private final CheckpointQueue queue = new CheckpointQueue(10);
    private final Thread checkpointThread;
    private final IndexFileManager indexFileManager;
    private final FailureProcessor failureProcessor;

    RaftLogCheckpointer(String nodeName, IndexFileManager indexFileManager, FailureProcessor failureProcessor) {
        this.indexFileManager = indexFileManager;
        this.failureProcessor = failureProcessor;
        this.checkpointThread = new IgniteThread(nodeName, "segstore-checkpoint", (Runnable)new CheckpointTask(), new ThreadOperation[0]);
    }

    void start() {
        this.checkpointThread.start();
    }

    void stop() {
        this.checkpointThread.interrupt();
        try {
            this.checkpointThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Marshalling.COMMON_ERR, "Interrupted while waiting for the checkpoint thread to finish.", (Throwable)e);
        }
    }

    void onRollover(SegmentFile segmentFile, ReadModeIndexMemTable indexMemTable) {
        try {
            this.queue.add(segmentFile, indexMemTable);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException(ErrorGroups.Marshalling.COMMON_ERR, "Interrupted while adding an entry to the checkpoint queue.", (Throwable)e);
        }
    }

    private class CheckpointTask
    implements Runnable {
        private CheckpointTask() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CheckpointQueue.Entry entry = RaftLogCheckpointer.this.queue.peek();
                        entry.segmentFile().sync();
                        RaftLogCheckpointer.this.indexFileManager.saveIndexMemtable(entry.memTable());
                        RaftLogCheckpointer.this.queue.removeHead();
                    }
                }
                catch (InterruptedException | ClosedByInterruptException e) {
                    return;
                }
                catch (IOException e) {
                    RaftLogCheckpointer.this.failureProcessor.process(new FailureContext(FailureType.CRITICAL_ERROR, (Throwable)e));
                    continue;
                }
                break;
            }
        }
    }
}

