/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.TimeoutNowRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.TimeoutNowRequestSerializer;

public class TimeoutNowRequestImpl
implements RpcRequests.TimeoutNowRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3004;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final String serverId;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private TimeoutNowRequestImpl(String groupId, String peerId, String serverId, long term, HybridTimestamp timestamp) {
        this.groupId = groupId;
        this.peerId = peerId;
        this.serverId = serverId;
        this.term = term;
        this.timestamp = timestamp;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return TimeoutNowRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(TimeoutNowRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3004;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeoutNowRequestImpl otherMessage = (TimeoutNowRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.term, this.groupId, this.peerId, this.serverId, this.timestamp);
        return result;
    }

    public TimeoutNowRequestImpl clone() {
        try {
            return (TimeoutNowRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TimeoutNowRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements TimeoutNowRequestBuilder {
        private String groupId;
        private String peerId;
        private String serverId;
        private long term;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public TimeoutNowRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder serverId(String serverId) {
            Objects.requireNonNull(serverId, "serverId is not marked @Nullable");
            this.serverId = serverId;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public TimeoutNowRequestBuilder timestamp(HybridTimestamp timestamp) {
            Objects.requireNonNull(timestamp, "timestamp is not marked @Nullable");
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public RpcRequests.TimeoutNowRequest build() {
            return new TimeoutNowRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"), Objects.requireNonNull(this.serverId, "serverId is not marked @Nullable"), this.term, Objects.requireNonNull(this.timestamp, "timestamp is not marked @Nullable"));
        }

        @Override
        public RpcRequests.TimeoutNowRequest buildDeserialized() {
            return new TimeoutNowRequestImpl(this.groupId, this.peerId, this.serverId, this.term, this.timestamp);
        }
    }
}

