/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.ResetPeerRequestImpl;

class ResetPeerRequestSerializer
implements MessageSerializer<CliRequests.ResetPeerRequest> {
    public static final ResetPeerRequestSerializer INSTANCE = new ResetPeerRequestSerializer();

    private ResetPeerRequestSerializer() {
    }

    public boolean writeMessage(CliRequests.ResetPeerRequest msg, MessageWriter writer) throws MessageMappingException {
        ResetPeerRequestImpl message = (ResetPeerRequestImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.resetPeerRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeCollection("newPeersList", message.newPeersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeCollection("oldPeersList", message.oldPeersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("peerId", message.peerId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

