/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.CoalescedHeartbeatResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.CoalescedHeartbeatResponseSerializer;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class CoalescedHeartbeatResponseImpl
implements RpcRequests.CoalescedHeartbeatResponse,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3016;
    @IgniteToStringInclude
    private final Collection<Message> messages;

    private CoalescedHeartbeatResponseImpl(Collection<Message> messages) {
        this.messages = messages;
    }

    @Override
    public Collection<Message> messages() {
        return this.messages;
    }

    public MessageSerializer serializer() {
        return CoalescedHeartbeatResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(CoalescedHeartbeatResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3016;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CoalescedHeartbeatResponseImpl otherMessage = (CoalescedHeartbeatResponseImpl)other;
        return Objects.equals(this.messages, otherMessage.messages);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.messages);
        return result;
    }

    public CoalescedHeartbeatResponseImpl clone() {
        try {
            return (CoalescedHeartbeatResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CoalescedHeartbeatResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messages != null) {
            for (Message obj : this.messages) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.messages != null) {
            for (Message obj : this.messages) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements CoalescedHeartbeatResponseBuilder {
        private Collection<Message> messages;

        private Builder() {
        }

        @Override
        public CoalescedHeartbeatResponseBuilder messages(Collection<Message> messages) {
            Objects.requireNonNull(messages, "messages is not marked @Nullable");
            this.messages = messages;
            return this;
        }

        @Override
        public Collection<Message> messages() {
            return this.messages;
        }

        @Override
        public RpcRequests.CoalescedHeartbeatResponse build() {
            return new CoalescedHeartbeatResponseImpl(Objects.requireNonNull(this.messages, "messages is not marked @Nullable"));
        }

        @Override
        public RpcRequests.CoalescedHeartbeatResponse buildDeserialized() {
            return new CoalescedHeartbeatResponseImpl(this.messages);
        }
    }
}

