/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.rpc.ActionResponse;
import org.apache.ignite.raft.jraft.rpc.ActionResponseBuilder;

class ActionResponseDeserializer
implements MessageDeserializer<ActionResponse> {
    private final ActionResponseBuilder msg;

    ActionResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.actionResponse();
    }

    public Class<ActionResponse> klass() {
        return ActionResponse.class;
    }

    public ActionResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.actionResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("resultByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.resultByteArray(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ActionResponse.class);
    }
}

