/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.entity.SnapshotMetaImpl;

class SnapshotMetaSerializer
implements MessageSerializer<RaftOutter.SnapshotMeta> {
    public static final SnapshotMetaSerializer INSTANCE = new SnapshotMetaSerializer();

    private SnapshotMetaSerializer() {
    }

    public boolean writeMessage(RaftOutter.SnapshotMeta msg, MessageWriter writer) throws MessageMappingException {
        SnapshotMetaImpl message = (SnapshotMetaImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.snapshotMeta());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)8)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("cfgIndex", message.cfgIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("cfgTerm", message.cfgTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeLong("lastIncludedIndex", message.lastIncludedIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeLong("lastIncludedTerm", message.lastIncludedTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeCollection("learnersList", message.learnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeCollection("oldLearnersList", message.oldLearnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeCollection("oldPeersList", message.oldPeersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeCollection("peersList", message.peersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

