/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.segstore;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileMeta;
import org.apache.ignite.internal.raft.storage.segstore.IndexFileMetaArray;
import org.apache.ignite.internal.raft.storage.segstore.IndexFilePointer;
import org.jetbrains.annotations.Nullable;

class GroupIndexMeta {
    private static final VarHandle FILE_METAS_VH;
    private final int startFileOrdinal;
    private volatile IndexFileMetaArray fileMetas;

    GroupIndexMeta(int startFileOrdinal, IndexFileMeta startFileMeta) {
        this.startFileOrdinal = startFileOrdinal;
        this.fileMetas = new IndexFileMetaArray(startFileMeta);
    }

    void addIndexMeta(IndexFileMeta indexFileMeta) {
        IndexFileMetaArray fileMetas = this.fileMetas;
        IndexFileMetaArray newFileMetas = fileMetas.add(indexFileMeta);
        boolean updated = FILE_METAS_VH.compareAndSet(this, fileMetas, newFileMetas);
        assert (updated) : "Concurrent writes detected";
    }

    @Nullable
    IndexFilePointer indexFilePointer(long logIndex) {
        IndexFileMetaArray fileMetas = this.fileMetas;
        int arrayIndex = fileMetas.find(logIndex);
        if (arrayIndex < 0) {
            return null;
        }
        IndexFileMeta meta = fileMetas.get(arrayIndex);
        return new IndexFilePointer(this.startFileOrdinal + arrayIndex, meta);
    }

    static {
        try {
            FILE_METAS_VH = MethodHandles.lookup().findVarHandle(GroupIndexMeta.class, "fileMetas", IndexFileMetaArray.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

