/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.configuration;

import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.raft.configuration.LogStorageConfigurationSchema;
import org.apache.ignite.internal.raft.configuration.LogStorageView;
import org.apache.ignite.internal.raft.configuration.ValidLogStorageConfiguration;

class LogStorageConfigurationValidator
implements Validator<ValidLogStorageConfiguration, LogStorageView> {
    static final LogStorageConfigurationValidator INSTANCE = new LogStorageConfigurationValidator();

    LogStorageConfigurationValidator() {
    }

    public void validate(ValidLogStorageConfiguration annotation, ValidationContext<LogStorageView> ctx) {
        LogStorageView newValue = (LogStorageView)ctx.getNewValue();
        LogStorageConfigurationValidator.validateLogEntrySize(newValue, ctx);
    }

    private static void validateLogEntrySize(LogStorageView config, ValidationContext<LogStorageView> ctx) {
        int maxEntrySize = config.maxLogEntrySizeBytes();
        if (maxEntrySize == -1) {
            return;
        }
        if (maxEntrySize <= 0) {
            String errorMsg = String.format("Maximum log entry size must be positive, got %d.", maxEntrySize);
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), errorMsg));
            return;
        }
        int maxAllowedEntrySize = LogStorageConfigurationSchema.computeDefaultMaxLogEntrySizeBytes(config.segmentFileSizeBytes());
        if (maxEntrySize > maxAllowedEntrySize) {
            String errorMsg = String.format("Maximum log entry size is too big (%d bytes), maximum allowed log entry size is %d bytes.", maxEntrySize, maxAllowedEntrySize);
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), errorMsg));
        }
    }
}

