/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft;

import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public class ReplicationGroupUnavailableException
extends IgniteException {
    private static final long serialVersionUID = 3692064399873450610L;
    private final ReplicationGroupId groupId;

    public ReplicationGroupUnavailableException(ReplicationGroupId groupId) {
        super(ErrorGroups.Replicator.GROUP_UNAVAILABLE_ERR, "Replication group is unavailable [groupId=" + groupId + "].");
        this.groupId = groupId;
    }

    public ReplicationGroupUnavailableException(ReplicationGroupId groupId, String message) {
        super(ErrorGroups.Replicator.GROUP_UNAVAILABLE_ERR, message);
        this.groupId = groupId;
    }

    public ReplicationGroupUnavailableException(ReplicationGroupId groupId, Throwable cause) {
        super(ErrorGroups.Replicator.GROUP_UNAVAILABLE_ERR, "Replication group is unavailable [groupId=" + groupId + "].", cause);
        this.groupId = groupId;
    }

    public ReplicationGroupId groupId() {
        return this.groupId;
    }
}

