/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.metrics;

import java.util.List;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.placementdriver.AssignmentsTracker;
import org.apache.ignite.internal.placementdriver.leases.Lease;
import org.apache.ignite.internal.placementdriver.leases.LeaseTracker;

public class PlacementDriverMetricSource
extends AbstractMetricSource<Holder> {
    public static final String SOURCE_NAME = "placement-driver";
    private final LeaseTracker leaseTracker;
    private final AssignmentsTracker assignmentsTracker;

    public PlacementDriverMetricSource(LeaseTracker leaseTracker, AssignmentsTracker assignmentsTracker) {
        super(SOURCE_NAME, "Placement driver metrics.");
        this.leaseTracker = leaseTracker;
        this.assignmentsTracker = assignmentsTracker;
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final IntGauge acceptedLeases = new IntGauge("AcceptedLeases", "Number of accepted leases.", () -> this.numberOfLeases(true));
        private final IntGauge leaseNegotiations = new IntGauge("LeaseNegotiations", "Number of leases under negotiation.", () -> this.numberOfLeases(false));
        private final IntGauge replicationGroups = new IntGauge("ReplicationGroups", "Current number of replication groups.", () -> PlacementDriverMetricSource.this.assignmentsTracker.stableAssignments().size());
        private final List<Metric> metrics = List.of(this.acceptedLeases, this.leaseNegotiations, this.replicationGroups);

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }

        private int numberOfLeases(boolean accepted) {
            int count = 0;
            for (Lease lease : PlacementDriverMetricSource.this.leaseTracker.leasesCurrent().leaseByGroupId().values()) {
                if (lease == null || accepted != lease.isAccepted()) continue;
                ++count;
            }
            return count;
        }
    }
}

