/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.leases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.distributionzones.exception.EmptyDataNodesException;
import org.apache.ignite.internal.event.AbstractEventProducer;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.placementdriver.LeasePlacementDriver;
import org.apache.ignite.internal.placementdriver.PlacementDriverManager;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitException;
import org.apache.ignite.internal.placementdriver.PrimaryReplicaAwaitTimeoutException;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.placementdriver.Utils;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.placementdriver.leases.Lease;
import org.apache.ignite.internal.placementdriver.leases.LeaseBatch;
import org.apache.ignite.internal.placementdriver.leases.Leases;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteBusyLock;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.util.PendingIndependentComparableValuesTracker;
import org.apache.ignite.internal.util.TrackerClosedException;
import org.jetbrains.annotations.Nullable;

public class LeaseTracker
extends AbstractEventProducer<PrimaryReplicaEvent, PrimaryReplicaEventParameters>
implements LeasePlacementDriver {
    private static final IgniteLogger LOG = Loggers.forClass(LeaseTracker.class);
    private final MetaStorageManager msManager;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private volatile Leases leases = new Leases(Collections.emptyMap(), ArrayUtils.BYTE_EMPTY_ARRAY);
    private final Map<ReplicationGroupId, PendingIndependentComparableValuesTracker<HybridTimestamp, ReplicaMeta>> primaryReplicaWaiters = new ConcurrentHashMap<ReplicationGroupId, PendingIndependentComparableValuesTracker<HybridTimestamp, ReplicaMeta>>();
    private final Map<ReplicationGroupId, CompletableFuture<Void>> expirationFutureByGroup = new ConcurrentHashMap<ReplicationGroupId, CompletableFuture<Void>>();
    private final UpdateListener updateListener = new UpdateListener();
    private final ClusterNodeResolver clusterNodeResolver;
    private final ClockService clockService;
    private final Function<Integer, CompletableFuture<Set<String>>> currentDataNodesProvider;
    private final Function<Integer, Integer> zoneIdByTableIdResolver;
    private final NodeProperties nodeProperties;

    public LeaseTracker(MetaStorageManager msManager, ClusterNodeResolver clusterNodeResolver, ClockService clockService, Function<Integer, CompletableFuture<Set<String>>> currentDataNodesProvider, Function<Integer, Integer> zoneIdByTableIdResolver, NodeProperties nodeProperties) {
        this.msManager = msManager;
        this.clusterNodeResolver = clusterNodeResolver;
        this.clockService = clockService;
        this.currentDataNodesProvider = currentDataNodesProvider;
        this.zoneIdByTableIdResolver = zoneIdByTableIdResolver;
        this.nodeProperties = nodeProperties;
    }

    public void startTrack(long recoveryRevision) {
        IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
            this.msManager.registerExactWatch(PlacementDriverManager.PLACEMENTDRIVER_LEASES_KEY, (WatchListener)this.updateListener);
            this.loadLeasesBusyAsync(recoveryRevision);
        });
    }

    public void stopTrack() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        this.primaryReplicaWaiters.values().forEach(PendingComparableValuesTracker::close);
        this.primaryReplicaWaiters.clear();
        this.msManager.unregisterWatch((WatchListener)this.updateListener);
    }

    public CompletableFuture<Void> previousPrimaryExpired(ReplicationGroupId grpId) {
        return this.expirationFutureByGroup.getOrDefault(grpId, CompletableFutures.nullCompletedFuture());
    }

    public Lease getLease(ReplicationGroupId grpId) {
        Leases leases = this.leases;
        assert (leases != null) : "Leases not initialized, probably the local placement driver actor hasn't started lease tracking.";
        Lease lease = leases.leaseByGroupId().get(grpId);
        return lease == null ? Lease.emptyLease(grpId) : lease;
    }

    public Leases leasesCurrent() {
        return this.leases;
    }

    private void enqueuePrimaryReplicaEvents(List<Supplier<CompletableFuture<?>>> eventsQueue, @Nullable Lease previousLease, @Nullable Lease newLease, long causalityToken) {
        boolean needToFirePrimaryExpiredEvent = LeaseTracker.needToFirePrimaryReplicaExpiredEvent(previousLease, newLease);
        boolean needToFirePrimaryElectedEvent = LeaseTracker.needToFirePrimaryReplicaElectedEvent(previousLease, newLease);
        if (needToFirePrimaryElectedEvent && needToFirePrimaryExpiredEvent) {
            assert (previousLease != null);
            assert (newLease != null);
            eventsQueue.add(() -> this.firePrimaryReplicaExpiredEvent(causalityToken, previousLease).thenCompose(v -> this.firePrimaryReplicaElectedEvent(causalityToken, newLease)));
        } else if (needToFirePrimaryExpiredEvent) {
            assert (previousLease != null);
            eventsQueue.add(() -> this.firePrimaryReplicaExpiredEvent(causalityToken, previousLease));
        } else if (needToFirePrimaryElectedEvent) {
            assert (newLease != null);
            eventsQueue.add(() -> this.firePrimaryReplicaElectedEvent(causalityToken, newLease));
        }
    }

    public CompletableFuture<ReplicaMeta> awaitPrimaryReplica(ReplicationGroupId groupId, HybridTimestamp timestamp, long timeout, TimeUnit unit) {
        return IgniteUtils.inBusyLockAsync((IgniteBusyLock)this.busyLock, () -> {
            ReplicaMeta currentMeta = this.getCurrentPrimaryReplica(groupId, timestamp);
            if (this.isValidReplicaMeta(currentMeta)) {
                return CompletableFuture.completedFuture(currentMeta);
            }
            return this.awaitPrimaryReplicaImpl(groupId, timestamp, timeout, unit);
        });
    }

    private CompletableFuture<ReplicaMeta> awaitPrimaryReplicaImpl(ReplicationGroupId groupId, HybridTimestamp timestamp, long timeout, TimeUnit unit) {
        return ((CompletableFuture)this.awaitPrimaryReplicaImpl(groupId, timestamp, System.nanoTime(), unit.toNanos(timeout)).handle((replicaMeta, e) -> {
            if (e == null) {
                return CompletableFuture.completedFuture(replicaMeta);
            }
            CompletableFuture failed = new CompletableFuture();
            if (ExceptionUtils.hasCause((Throwable)e, (Class[])new Class[]{TimeoutException.class})) {
                ((CompletableFuture)this.checkDataNodes(groupId).thenRun(() -> {
                    throw new PrimaryReplicaAwaitTimeoutException(groupId, timestamp, (ReplicaMeta)this.leases.leaseByGroupId().get(groupId), e);
                })).exceptionally(ex -> {
                    failed.completeExceptionally((Throwable)ex);
                    return null;
                });
            } else if (ExceptionUtils.hasCause((Throwable)e, (Class[])new Class[]{TrackerClosedException.class})) {
                failed.completeExceptionally(new CompletionException(new NodeStoppingException(e)));
            } else {
                failed.completeExceptionally((Throwable)new PrimaryReplicaAwaitException(groupId, timestamp, e));
            }
            return failed;
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<ReplicaMeta> awaitPrimaryReplicaImpl(ReplicationGroupId groupId, HybridTimestamp timestamp, long startNanoTime, long timeoutNanos) {
        return IgniteUtils.inBusyLockAsync((IgniteBusyLock)this.busyLock, () -> {
            long elapsedNanos = System.nanoTime() - startNanoTime;
            long remainingTimeoutNanos = timeoutNanos - elapsedNanos;
            if (remainingTimeoutNanos <= 0L) {
                return CompletableFuture.failedFuture(new TimeoutException());
            }
            return this.getOrCreatePrimaryReplicaWaiter(groupId).waitFor((Comparable)timestamp).orTimeout(remainingTimeoutNanos, TimeUnit.NANOSECONDS).thenCompose(replicaMeta -> {
                if (this.isValidReplicaMeta((ReplicaMeta)replicaMeta)) {
                    return CompletableFuture.completedFuture(replicaMeta);
                }
                return this.awaitPrimaryReplicaImpl(groupId, replicaMeta.getExpirationTime().tick(), startNanoTime, timeoutNanos);
            });
        });
    }

    private CompletableFuture<Void> checkDataNodes(ReplicationGroupId groupId) {
        Integer zoneId = Utils.extractZoneIdFromGroupId(groupId, this.nodeProperties.colocationEnabled(), this.zoneIdByTableIdResolver);
        if (zoneId != null) {
            return this.currentDataNodesProvider.apply(zoneId).thenAccept(dataNodes -> {
                if (dataNodes.isEmpty()) {
                    throw new EmptyDataNodesException(zoneId.intValue());
                }
            });
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private boolean isValidReplicaMeta(@Nullable ReplicaMeta replicaMeta) {
        UUID leaseholderId = replicaMeta == null ? null : replicaMeta.getLeaseholderId();
        return leaseholderId != null && this.clusterNodeResolver.getById(leaseholderId) != null;
    }

    public CompletableFuture<ReplicaMeta> getPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        return IgniteUtils.inBusyLockAsync((IgniteBusyLock)this.busyLock, () -> {
            Lease lease = this.getLease(replicationGroupId);
            if (lease.isAccepted() && this.clockService.after(lease.getExpirationTime(), timestamp)) {
                return CompletableFuture.completedFuture(lease);
            }
            return this.msManager.clusterTime().waitFor(timestamp.addPhysicalTime(this.clockService.maxClockSkewMillis())).thenApply(ignored -> (ReplicaMeta)IgniteUtils.inBusyLock((IgniteBusyLock)this.busyLock, () -> {
                Lease lease0 = this.getLease(replicationGroupId);
                if (lease0.isAccepted() && this.clockService.after(lease0.getExpirationTime(), timestamp)) {
                    return lease0;
                }
                return null;
            }));
        });
    }

    @Nullable
    public ReplicaMeta getCurrentPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        Lease lease = this.getLease(replicationGroupId);
        if (lease.isAccepted() && this.clockService.after(lease.getExpirationTime(), timestamp)) {
            return lease;
        }
        return null;
    }

    private void tryRemoveTracker(ReplicationGroupId groupId) {
        this.primaryReplicaWaiters.computeIfPresent(groupId, (groupId0, tracker0) -> {
            if (tracker0.isEmpty()) {
                return null;
            }
            return tracker0;
        });
    }

    private PendingIndependentComparableValuesTracker<HybridTimestamp, ReplicaMeta> getOrCreatePrimaryReplicaWaiter(ReplicationGroupId groupId) {
        return this.primaryReplicaWaiters.computeIfAbsent(groupId, key -> new PendingIndependentComparableValuesTracker((Comparable)HybridTimestamp.MIN_VALUE));
    }

    private void loadLeasesBusyAsync(long recoveryRevision) {
        Entry entry = this.msManager.getLocally(PlacementDriverManager.PLACEMENTDRIVER_LEASES_KEY, recoveryRevision);
        if (entry.empty() || entry.tombstone()) {
            this.leases = new Leases(Map.of(), ArrayUtils.BYTE_EMPTY_ARRAY);
        } else {
            byte[] leasesBytes = entry.value();
            assert (leasesBytes != null);
            LeaseBatch leaseBatch = LeaseBatch.fromBytes(leasesBytes);
            HashMap leasesMap = IgniteUtils.newHashMap((int)leaseBatch.leases().size());
            leaseBatch.leases().forEach(lease -> {
                ReplicationGroupId grpId = lease.replicationGroupId();
                leasesMap.put(grpId, lease);
                if (lease.isAccepted()) {
                    this.getOrCreatePrimaryReplicaWaiter(grpId).update((Comparable)lease.getExpirationTime(), lease);
                }
            });
            this.leases = new Leases(leasesMap, leasesBytes);
        }
        LOG.info("Leases cache recovered [leases={}]", new Object[]{this.leases});
    }

    private CompletableFuture<Void> firePrimaryReplicaExpiredEvent(long causalityToken, Lease expiredLease) {
        ReplicationGroupId grpId = expiredLease.replicationGroupId();
        CompletableFuture eventFuture = this.fireEvent((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_EXPIRED, (EventParameters)new PrimaryReplicaEventParameters(causalityToken, grpId, expiredLease.getLeaseholderId(), expiredLease.getLeaseholder(), expiredLease.getStartTime()));
        CompletableFuture<Void> prev = this.expirationFutureByGroup.put(grpId, eventFuture);
        assert (prev == null || prev.isDone()) : "Previous lease expiration process has not completed yet [grpId=" + grpId + "]";
        return eventFuture;
    }

    private CompletableFuture<Void> firePrimaryReplicaElectedEvent(long causalityToken, Lease lease) {
        UUID leaseholderId = lease.getLeaseholderId();
        assert (leaseholderId != null) : lease;
        return this.fireEvent((Event)PrimaryReplicaEvent.PRIMARY_REPLICA_ELECTED, (EventParameters)new PrimaryReplicaEventParameters(causalityToken, lease.replicationGroupId(), leaseholderId, lease.getLeaseholder(), lease.getStartTime()));
    }

    private static boolean needToFirePrimaryReplicaExpiredEvent(@Nullable Lease previousLease, @Nullable Lease newLease) {
        return LeaseTracker.isAccepted(previousLease) && (newLease == null || !LeaseTracker.isSameLease(previousLease, newLease));
    }

    private static boolean needToFirePrimaryReplicaElectedEvent(@Nullable Lease previousLease, @Nullable Lease newLease) {
        return LeaseTracker.isAccepted(newLease) && (!LeaseTracker.isAccepted(previousLease) || !LeaseTracker.isSameLease(previousLease, newLease));
    }

    private static boolean isSameLease(Lease previousLease, Lease newLease) {
        return previousLease.getStartTime().equals((Object)newLease.getStartTime());
    }

    private static boolean isAccepted(@Nullable Lease lease) {
        return lease != null && lease.isAccepted();
    }

    private class UpdateListener
    implements WatchListener {
        private UpdateListener() {
        }

        public CompletableFuture<Void> onUpdate(WatchEvent event) {
            return IgniteUtils.inBusyLockAsync((IgniteBusyLock)LeaseTracker.this.busyLock, () -> {
                void var10_13;
                Lease previousLease;
                ReplicationGroupId grpId;
                ArrayList eventsToFire = new ArrayList();
                long eventRevision = event.revision();
                byte[] leasesBytes = event.entryEvent().newEntry().value();
                assert (leasesBytes != null);
                LeaseBatch leaseBatch = LeaseBatch.fromBytes(leasesBytes);
                HashMap newLeasesMap = IgniteUtils.newHashMap((int)leaseBatch.leases().size());
                Map<ReplicationGroupId, Lease> previousLeasesMap = LeaseTracker.this.leases.leaseByGroupId();
                for (Lease lease : leaseBatch.leases()) {
                    grpId = lease.replicationGroupId();
                    newLeasesMap.put(grpId, lease);
                    if (lease.isAccepted()) {
                        LeaseTracker.this.getOrCreatePrimaryReplicaWaiter(grpId).update((Comparable)lease.getExpirationTime(), (Object)lease);
                    }
                    previousLease = previousLeasesMap.get(grpId);
                    LeaseTracker.this.enqueuePrimaryReplicaEvents(eventsToFire, previousLease, lease, eventRevision);
                }
                for (Map.Entry entry : previousLeasesMap.entrySet()) {
                    grpId = (ReplicationGroupId)entry.getKey();
                    if (newLeasesMap.containsKey(grpId)) continue;
                    LeaseTracker.this.tryRemoveTracker(grpId);
                    previousLease = (Lease)entry.getValue();
                    LeaseTracker.this.enqueuePrimaryReplicaEvents(eventsToFire, previousLease, null, eventRevision);
                }
                LeaseTracker.this.leases = new Leases(newLeasesMap, leasesBytes);
                CompletableFuture[] eventFutures = new CompletableFuture[eventsToFire.size()];
                boolean bl = false;
                while (var10_13 < eventsToFire.size()) {
                    eventFutures[var10_13] = eventsToFire.get((int)var10_13).get();
                    ++var10_13;
                }
                return CompletableFuture.allOf(eventFutures);
            });
        }
    }
}

