/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.message;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessage;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageImpl;
import org.apache.ignite.internal.placementdriver.message.PlacementDriverMessagesTypeInfos;

class LeaseGrantedMessageSerializer
implements MessageSerializer<LeaseGrantedMessage> {
    public static final LeaseGrantedMessageSerializer INSTANCE = new LeaseGrantedMessageSerializer();

    private LeaseGrantedMessageSerializer() {
    }

    public boolean writeMessage(LeaseGrantedMessage msg, MessageWriter writer) throws MessageMappingException {
        LeaseGrantedMessageImpl message = (LeaseGrantedMessageImpl)msg;
        writer.setMessageTypeInfo(PlacementDriverMessagesTypeInfos.leaseGrantedMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("force", message.force());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteArray("groupIdByteArray", message.groupIdByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeHybridTimestamp("leaseExpirationTime", message.leaseExpirationTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("leaseStartTime", message.leaseStartTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

