/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.message;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageResponse;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageResponseBuilder;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageResponseSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class LeaseGrantedMessageResponseImpl
implements LeaseGrantedMessageResponse,
Cloneable {
    public static final short GROUP_TYPE = 11;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final boolean accepted;
    @IgniteToStringInclude
    private final String redirectProposal;

    private LeaseGrantedMessageResponseImpl(boolean accepted, String redirectProposal) {
        this.accepted = accepted;
        this.redirectProposal = redirectProposal;
    }

    @Override
    public boolean accepted() {
        return this.accepted;
    }

    @Override
    public String redirectProposal() {
        return this.redirectProposal;
    }

    public MessageSerializer serializer() {
        return LeaseGrantedMessageResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 11;
    }

    public String toString() {
        return S.toString(LeaseGrantedMessageResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LeaseGrantedMessageResponseImpl otherMessage = (LeaseGrantedMessageResponseImpl)other;
        return Objects.equals(this.redirectProposal, otherMessage.redirectProposal) && this.accepted == otherMessage.accepted;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.accepted, this.redirectProposal);
        return result;
    }

    public LeaseGrantedMessageResponseImpl clone() {
        try {
            return (LeaseGrantedMessageResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LeaseGrantedMessageResponseBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements LeaseGrantedMessageResponseBuilder {
        private boolean accepted;
        private String redirectProposal;

        private Builder() {
        }

        @Override
        public LeaseGrantedMessageResponseBuilder accepted(boolean accepted) {
            this.accepted = accepted;
            return this;
        }

        @Override
        public LeaseGrantedMessageResponseBuilder redirectProposal(String redirectProposal) {
            this.redirectProposal = redirectProposal;
            return this;
        }

        @Override
        public boolean accepted() {
            return this.accepted;
        }

        @Override
        public String redirectProposal() {
            return this.redirectProposal;
        }

        @Override
        public LeaseGrantedMessageResponse build() {
            return new LeaseGrantedMessageResponseImpl(this.accepted, this.redirectProposal);
        }

        @Override
        public LeaseGrantedMessageResponse buildDeserialized() {
            return new LeaseGrantedMessageResponseImpl(this.accepted, this.redirectProposal);
        }
    }
}

