/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.wrappers;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.placementdriver.wrappers.DelegatingPlacementDriver;
import org.apache.ignite.internal.replicator.ReplicationGroupId;

public class ExecutorInclinedPlacementDriver
extends DelegatingPlacementDriver {
    private final Executor completionExecutor;

    public ExecutorInclinedPlacementDriver(PlacementDriver placementDriver, Executor completionExecutor) {
        super(placementDriver);
        this.completionExecutor = completionExecutor;
    }

    @Override
    public CompletableFuture<ReplicaMeta> awaitPrimaryReplica(ReplicationGroupId groupId, HybridTimestamp timestamp, long timeout, TimeUnit unit) {
        return this.decorateFuture(super.awaitPrimaryReplica(groupId, timestamp, timeout, unit));
    }

    private <T> CompletableFuture<T> decorateFuture(CompletableFuture<T> future) {
        if (future.isDone()) {
            return future;
        }
        return future.thenApplyAsync(Function.identity(), this.completionExecutor);
    }

    @Override
    public CompletableFuture<ReplicaMeta> getPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        return this.decorateFuture(super.getPrimaryReplica(replicationGroupId, timestamp));
    }

    @Override
    public CompletableFuture<Void> previousPrimaryExpired(ReplicationGroupId grpId) {
        return this.decorateFuture(super.previousPrimaryExpired(grpId));
    }

    @Override
    public CompletableFuture<List<TokenizedAssignments>> awaitNonEmptyAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp clusterTimeToAwait, long timeoutMillis) {
        return this.decorateFuture(super.awaitNonEmptyAssignments(replicationGroupIds, clusterTimeToAwait, timeoutMillis));
    }
}

