/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.wrappers;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partitiondistribution.TokenizedAssignments;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEvent;
import org.apache.ignite.internal.placementdriver.event.PrimaryReplicaEventParameters;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.jetbrains.annotations.Nullable;

abstract class DelegatingPlacementDriver
implements PlacementDriver {
    private final PlacementDriver delegate;

    DelegatingPlacementDriver(PlacementDriver delegate) {
        this.delegate = delegate;
    }

    public void listen(PrimaryReplicaEvent evt, EventListener<? extends PrimaryReplicaEventParameters> listener) {
        this.delegate.listen(evt, listener);
    }

    public void removeListener(PrimaryReplicaEvent evt, EventListener<? extends PrimaryReplicaEventParameters> listener) {
        this.delegate.removeListener(evt, listener);
    }

    @Override
    public CompletableFuture<ReplicaMeta> awaitPrimaryReplica(ReplicationGroupId groupId, HybridTimestamp timestamp, long timeout, TimeUnit unit) {
        return this.delegate.awaitPrimaryReplica(groupId, timestamp, timeout, unit);
    }

    @Override
    public CompletableFuture<ReplicaMeta> getPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        return this.delegate.getPrimaryReplica(replicationGroupId, timestamp);
    }

    @Override
    @Nullable
    public ReplicaMeta getCurrentPrimaryReplica(ReplicationGroupId replicationGroupId, HybridTimestamp timestamp) {
        return this.delegate.getCurrentPrimaryReplica(replicationGroupId, timestamp);
    }

    @Override
    public CompletableFuture<List<TokenizedAssignments>> awaitNonEmptyAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp clusterTimeToAwait, long timeoutMillis) {
        return this.delegate.awaitNonEmptyAssignments(replicationGroupIds, clusterTimeToAwait, timeoutMillis);
    }

    @Override
    public CompletableFuture<Void> previousPrimaryExpired(ReplicationGroupId grpId) {
        return this.delegate.previousPrimaryExpired(grpId);
    }

    @Override
    public CompletableFuture<List<TokenizedAssignments>> getAssignments(List<? extends ReplicationGroupId> replicationGroupIds, HybridTimestamp clusterTimeToAwait) {
        return this.delegate.getAssignments(replicationGroupIds, clusterTimeToAwait);
    }

    @Override
    public boolean isActualAt(HybridTimestamp timestamp) {
        return this.delegate.isActualAt(timestamp);
    }
}

