/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMeta;
import org.apache.ignite.internal.partition.replicator.network.raft.PartitionSnapshotMetaBuilder;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;
import org.apache.ignite.internal.storage.RowId;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.jetbrains.annotations.Nullable;

public class SnapshotMetaUtils {
    private static final PartitionReplicationMessagesFactory MESSAGE_FACTORY = new PartitionReplicationMessagesFactory();

    public static PartitionSnapshotMeta snapshotMetaAt(long logIndex, long term, RaftGroupConfiguration config, int requiredCatalogVersion, Map<Integer, UUID> nextRowIdToBuildByIndexId, @Nullable LeaseInfo leaseInfo) {
        PartitionSnapshotMetaBuilder metaBuilder = MESSAGE_FACTORY.partitionSnapshotMeta().cfgIndex(config.index()).cfgTerm(config.term()).sequenceToken(config.sequenceToken()).oldSequenceToken(config.oldSequenceToken()).lastIncludedIndex(logIndex).lastIncludedTerm(term).peersList(config.peers()).learnersList(config.learners()).requiredCatalogVersion(requiredCatalogVersion).nextRowIdToBuildByIndexId(nextRowIdToBuildByIndexId);
        if (leaseInfo != null) {
            metaBuilder.leaseStartTime(leaseInfo.leaseStartTime()).primaryReplicaNodeId(leaseInfo.primaryReplicaNodeId()).primaryReplicaNodeName(leaseInfo.primaryReplicaNodeName());
        }
        if (!config.isStable()) {
            metaBuilder.oldPeersList(config.oldPeers()).oldLearnersList(config.oldLearners());
        }
        return metaBuilder.build();
    }

    public static Map<Integer, UUID> collectNextRowIdToBuildIndexes(CatalogService catalogService, Collection<PartitionMvStorageAccess> mvPartitions, int catalogVersion) {
        HashMap<Integer, UUID> nextRowIdToBuildByIndexId = new HashMap<Integer, UUID>();
        Catalog catalog = catalogService.catalog(catalogVersion);
        for (PartitionMvStorageAccess mvPartition : mvPartitions) {
            int tableId = mvPartition.tableId();
            for (CatalogIndexDescriptor index : catalog.indexes(tableId)) {
                RowId nextRowIdToBuild;
                if (index.status() != CatalogIndexStatus.BUILDING || (nextRowIdToBuild = mvPartition.getNextRowIdToBuildIndex(index.id())) == null) continue;
                nextRowIdToBuildByIndexId.put(index.id(), nextRowIdToBuild.uuid());
            }
        }
        return nextRowIdToBuildByIndexId;
    }
}

