/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metrics.StopWatchTimer;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.raft.RaftGroupConfiguration;

class OutgoingSnapshotStats {
    private static final IgniteLogger LOG = Loggers.forClass(OutgoingSnapshotStats.class);
    long rowsSent;
    long rowVersionsSent;
    long totalBytesSent;
    long outOfOrderRowsSent;
    long outOfOrderVersionsSent;
    long outOfOrderTotalBytesSent;
    int totalBatches;
    private final StopWatchTimer currentBatchTimer = new StopWatchTimer();
    long combinedBatchDuration;
    long minBatchDuration;
    long maxBatchDuration;
    final StopWatchTimer totalSnapshotTimer = new StopWatchTimer();
    long lastIncludedIndex;
    long lastIncludedTerm;
    final List<String> peers = new ArrayList<String>();
    final List<String> oldPeers = new ArrayList<String>();
    final List<String> learners = new ArrayList<String>();
    final List<String> oldLearners = new ArrayList<String>();
    int catalogVersion;
    private final UUID snapshotId;
    private final PartitionKey partitionKey;

    OutgoingSnapshotStats(UUID snapshotId, PartitionKey partitionKey) {
        this.snapshotId = snapshotId;
        this.partitionKey = partitionKey;
    }

    void onSnapshotStart() {
        this.totalSnapshotTimer.start();
    }

    void onSnapshotEnd() {
        this.totalSnapshotTimer.end();
    }

    void setSnapshotMeta(long lastAppliedIndex, long lastAppliedTerm, RaftGroupConfiguration config, int catalogVersion) {
        this.lastIncludedIndex = lastAppliedIndex;
        this.lastIncludedTerm = lastAppliedTerm;
        this.catalogVersion = catalogVersion;
        this.peers.addAll(config.peers());
        List oldPeers = config.oldPeers();
        if (oldPeers != null) {
            this.oldPeers.addAll(oldPeers);
        }
        this.learners.addAll(config.learners());
        List oldLearners = config.oldLearners();
        if (oldLearners != null) {
            this.oldLearners.addAll(oldLearners);
        }
    }

    void onStartMvDataBatchProcessing() {
        this.currentBatchTimer.start();
    }

    void onEndMvDataBatchProcessing() {
        this.currentBatchTimer.end();
        ++this.totalBatches;
        long batchDuration = this.currentBatchTimer.duration(TimeUnit.MILLISECONDS);
        this.minBatchDuration = this.totalBatches == 1 ? batchDuration : Math.min(this.minBatchDuration, batchDuration);
        this.maxBatchDuration = Math.max(this.maxBatchDuration, batchDuration);
        this.combinedBatchDuration += batchDuration;
    }

    void onProcessOutOfOrderRow(long rowVersions, long totalBytes) {
        ++this.outOfOrderRowsSent;
        this.outOfOrderVersionsSent += rowVersions;
        this.outOfOrderTotalBytesSent += totalBytes;
    }

    void onProcessRegularRow(long rowVersions, long totalBytes) {
        ++this.rowsSent;
        this.rowVersionsSent += rowVersions;
        this.totalBytesSent += totalBytes;
    }

    void logSnapshotStats() {
        if (LOG.isInfoEnabled()) {
            LOG.info("Outgoing snapshot installation completed [partitionKey={}, snapshotId={}, rows={}, rowVersions={}, totalBytes={},  outOfOrderRows={}, outOfOrderVersions={}, outOfOrderTotalBytes={}, totalBatches={}, avgBatchProcessingTime={}ms, minBatchProcessingTime={}ms, maxBatchProcessingTime={}ms, totalSnapshotInstallationTime={}ms, lastIncludedIndex={}, lastIncludedTerm={}, peers=[{}], oldPeers=[{}], learners=[{}], oldLearners=[{}], catalogVersion={}]", new Object[]{this.partitionKey, this.snapshotId, this.rowsSent + this.outOfOrderRowsSent, this.rowVersionsSent + this.outOfOrderVersionsSent, this.totalBytesSent + this.outOfOrderTotalBytesSent, this.outOfOrderRowsSent, this.outOfOrderVersionsSent, this.outOfOrderTotalBytesSent, this.totalBatches, this.totalBatches > 0 ? this.combinedBatchDuration / (long)this.totalBatches : 0L, this.minBatchDuration, this.maxBatchDuration, this.totalSnapshotTimer.duration(TimeUnit.MILLISECONDS), this.lastIncludedIndex, this.lastIncludedTerm, this.peers, this.oldPeers, this.learners, this.oldLearners, this.catalogVersion});
        }
    }
}

