/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultipleRowsSecondaryReplicaRequestImpl;

class ReadWriteMultipleRowsSecondaryReplicaRequestSerializer
implements MessageSerializer<ReadWriteMultipleRowsSecondaryReplicaRequest> {
    public static final ReadWriteMultipleRowsSecondaryReplicaRequestSerializer INSTANCE = new ReadWriteMultipleRowsSecondaryReplicaRequestSerializer();

    private ReadWriteMultipleRowsSecondaryReplicaRequestSerializer() {
    }

    public boolean writeMessage(ReadWriteMultipleRowsSecondaryReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadWriteMultipleRowsSecondaryReplicaRequestImpl message = (ReadWriteMultipleRowsSecondaryReplicaRequestImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readWriteMultipleRowsSecondaryReplicaRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                int idShifted = message.requestType() == null ? 0 : message.requestType().id() + 1;
                boolean written = writer.writeInt("requestType", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeList("rows", message.rows(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

