/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowVersionMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowVersionMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryRowVersionMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class BinaryRowVersionMessageImpl
implements BinaryRowVersionMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16377;
    @IgniteToStringInclude
    private final ByteBuffer binaryTuple;
    @IgniteToStringInclude
    private final boolean isArchived;
    @IgniteToStringInclude
    private final int schemaVersion;
    @IgniteToStringInclude
    private final boolean tombstone;

    private BinaryRowVersionMessageImpl(ByteBuffer binaryTuple, boolean isArchived, int schemaVersion, boolean tombstone) {
        this.binaryTuple = binaryTuple;
        this.isArchived = isArchived;
        this.schemaVersion = schemaVersion;
        this.tombstone = tombstone;
    }

    @Override
    public ByteBuffer binaryTuple() {
        return this.binaryTuple;
    }

    @Override
    public boolean isArchived() {
        return this.isArchived;
    }

    @Override
    public int schemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public boolean tombstone() {
        return this.tombstone;
    }

    public MessageSerializer serializer() {
        return BinaryRowVersionMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(BinaryRowVersionMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 16377;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BinaryRowVersionMessageImpl otherMessage = (BinaryRowVersionMessageImpl)other;
        return Objects.equals(this.binaryTuple, otherMessage.binaryTuple) && this.isArchived == otherMessage.isArchived && this.schemaVersion == otherMessage.schemaVersion && this.tombstone == otherMessage.tombstone;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.isArchived, this.schemaVersion, this.tombstone, this.binaryTuple);
        return result;
    }

    public BinaryRowVersionMessageImpl clone() {
        try {
            return (BinaryRowVersionMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static BinaryRowVersionMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements BinaryRowVersionMessageBuilder {
        private ByteBuffer binaryTuple;
        private boolean isArchived;
        private int schemaVersion;
        private boolean tombstone;

        private Builder() {
        }

        @Override
        public BinaryRowVersionMessageBuilder binaryTuple(ByteBuffer binaryTuple) {
            this.binaryTuple = binaryTuple;
            return this;
        }

        @Override
        public BinaryRowVersionMessageBuilder isArchived(boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        @Override
        public BinaryRowVersionMessageBuilder schemaVersion(int schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public BinaryRowVersionMessageBuilder tombstone(boolean tombstone) {
            this.tombstone = tombstone;
            return this;
        }

        @Override
        public ByteBuffer binaryTuple() {
            return this.binaryTuple;
        }

        @Override
        public boolean isArchived() {
            return this.isArchived;
        }

        @Override
        public int schemaVersion() {
            return this.schemaVersion;
        }

        @Override
        public boolean tombstone() {
            return this.tombstone;
        }

        @Override
        public BinaryRowVersionMessage build() {
            return new BinaryRowVersionMessageImpl(this.binaryTuple, this.isArchived, this.schemaVersion, this.tombstone);
        }

        @Override
        public BinaryRowVersionMessage buildDeserialized() {
            return new BinaryRowVersionMessageImpl(this.binaryTuple, this.isArchived, this.schemaVersion, this.tombstone);
        }
    }
}

