/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.disaster.OperationCompletedMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.OperationCompletedMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.disaster.OperationCompletedMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class OperationCompletedMessageImpl
implements OperationCompletedMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 113;
    @IgniteToStringInclude
    private final String exceptionMessage;
    @IgniteToStringInclude
    private final UUID operationId;

    private OperationCompletedMessageImpl(String exceptionMessage, UUID operationId) {
        this.exceptionMessage = exceptionMessage;
        this.operationId = operationId;
    }

    @Override
    public String exceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    public MessageSerializer serializer() {
        return OperationCompletedMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(OperationCompletedMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 113;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OperationCompletedMessageImpl otherMessage = (OperationCompletedMessageImpl)other;
        return Objects.equals(this.exceptionMessage, otherMessage.exceptionMessage) && Objects.equals(this.operationId, otherMessage.operationId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.exceptionMessage, this.operationId);
        return result;
    }

    public OperationCompletedMessageImpl clone() {
        try {
            return (OperationCompletedMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static OperationCompletedMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements OperationCompletedMessageBuilder {
        private String exceptionMessage;
        private UUID operationId;

        private Builder() {
        }

        @Override
        public OperationCompletedMessageBuilder exceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        @Override
        public OperationCompletedMessageBuilder operationId(UUID operationId) {
            Objects.requireNonNull(operationId, "operationId is not marked @Nullable");
            this.operationId = operationId;
            return this;
        }

        @Override
        public String exceptionMessage() {
            return this.exceptionMessage;
        }

        @Override
        public UUID operationId() {
            return this.operationId;
        }

        @Override
        public OperationCompletedMessage build() {
            return new OperationCompletedMessageImpl(this.exceptionMessage, Objects.requireNonNull(this.operationId, "operationId is not marked @Nullable"));
        }

        @Override
        public OperationCompletedMessage buildDeserialized() {
            return new OperationCompletedMessageImpl(this.exceptionMessage, this.operationId);
        }
    }
}

