/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionsEstimatedSizeRequest;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionsEstimatedSizeRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.disaster.LocalPartitionsEstimatedSizeRequestSerializer;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class LocalPartitionsEstimatedSizeRequestImpl
implements LocalPartitionsEstimatedSizeRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 109;
    @IgniteToStringInclude
    private final int catalogVersion;
    @IgniteToStringInclude
    private final Set<ZonePartitionIdMessage> zonePartitionIds;

    private LocalPartitionsEstimatedSizeRequestImpl(int catalogVersion, Set<ZonePartitionIdMessage> zonePartitionIds) {
        this.catalogVersion = catalogVersion;
        this.zonePartitionIds = zonePartitionIds;
    }

    @Override
    public int catalogVersion() {
        return this.catalogVersion;
    }

    @Override
    public Set<ZonePartitionIdMessage> zonePartitionIds() {
        return this.zonePartitionIds;
    }

    public MessageSerializer serializer() {
        return LocalPartitionsEstimatedSizeRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(LocalPartitionsEstimatedSizeRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 109;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LocalPartitionsEstimatedSizeRequestImpl otherMessage = (LocalPartitionsEstimatedSizeRequestImpl)other;
        return Objects.equals(this.zonePartitionIds, otherMessage.zonePartitionIds) && this.catalogVersion == otherMessage.catalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.catalogVersion, this.zonePartitionIds);
        return result;
    }

    public LocalPartitionsEstimatedSizeRequestImpl clone() {
        try {
            return (LocalPartitionsEstimatedSizeRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static LocalPartitionsEstimatedSizeRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.zonePartitionIds != null) {
            for (ZonePartitionIdMessage obj : this.zonePartitionIds) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, (Object)marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.zonePartitionIds != null) {
            for (ZonePartitionIdMessage obj : this.zonePartitionIds) {
                if (obj == null) continue;
                obj.unmarshal((Object)marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements LocalPartitionsEstimatedSizeRequestBuilder {
        private int catalogVersion;
        private Set<ZonePartitionIdMessage> zonePartitionIds;

        private Builder() {
        }

        @Override
        public LocalPartitionsEstimatedSizeRequestBuilder catalogVersion(int catalogVersion) {
            this.catalogVersion = catalogVersion;
            return this;
        }

        @Override
        public LocalPartitionsEstimatedSizeRequestBuilder zonePartitionIds(Set<ZonePartitionIdMessage> zonePartitionIds) {
            Objects.requireNonNull(zonePartitionIds, "zonePartitionIds is not marked @Nullable");
            this.zonePartitionIds = zonePartitionIds;
            return this;
        }

        @Override
        public int catalogVersion() {
            return this.catalogVersion;
        }

        @Override
        public Set<ZonePartitionIdMessage> zonePartitionIds() {
            return this.zonePartitionIds;
        }

        @Override
        public LocalPartitionsEstimatedSizeRequest build() {
            return new LocalPartitionsEstimatedSizeRequestImpl(this.catalogVersion, Objects.requireNonNull(this.zonePartitionIds, "zonePartitionIds is not marked @Nullable"));
        }

        @Override
        public LocalPartitionsEstimatedSizeRequest buildDeserialized() {
            return new LocalPartitionsEstimatedSizeRequestImpl(this.catalogVersion, this.zonePartitionIds);
        }
    }
}

