/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessageImpl;

class DisasterRecoveryRequestMessageSerializer
implements MessageSerializer<DisasterRecoveryRequestMessage> {
    public static final DisasterRecoveryRequestMessageSerializer INSTANCE = new DisasterRecoveryRequestMessageSerializer();

    private DisasterRecoveryRequestMessageSerializer() {
    }

    public boolean writeMessage(DisasterRecoveryRequestMessage msg, MessageWriter writer) throws MessageMappingException {
        DisasterRecoveryRequestMessageImpl message = (DisasterRecoveryRequestMessageImpl)msg;
        writer.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.disasterRecoveryRequestMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteArray("requestBytes", message.requestBytes());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("revision", message.revision());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

