/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessageBuilder;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class DisasterRecoveryRequestMessageImpl
implements DisasterRecoveryRequestMessage,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 112;
    @IgniteToStringInclude
    private final byte[] requestBytes;
    @IgniteToStringInclude
    private final long revision;

    private DisasterRecoveryRequestMessageImpl(byte[] requestBytes, long revision) {
        this.requestBytes = requestBytes;
        this.revision = revision;
    }

    @Override
    public byte[] requestBytes() {
        return this.requestBytes;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    public MessageSerializer serializer() {
        return DisasterRecoveryRequestMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(DisasterRecoveryRequestMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 112;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DisasterRecoveryRequestMessageImpl otherMessage = (DisasterRecoveryRequestMessageImpl)other;
        return Arrays.equals(this.requestBytes, otherMessage.requestBytes) && this.revision == otherMessage.revision;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.revision);
        result = 31 * result + Arrays.hashCode(this.requestBytes);
        return result;
    }

    public DisasterRecoveryRequestMessageImpl clone() {
        try {
            return (DisasterRecoveryRequestMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static DisasterRecoveryRequestMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements DisasterRecoveryRequestMessageBuilder {
        private byte[] requestBytes;
        private long revision;

        private Builder() {
        }

        @Override
        public DisasterRecoveryRequestMessageBuilder requestBytes(byte[] requestBytes) {
            Objects.requireNonNull(requestBytes, "requestBytes is not marked @Nullable");
            this.requestBytes = requestBytes;
            return this;
        }

        @Override
        public DisasterRecoveryRequestMessageBuilder revision(long revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public byte[] requestBytes() {
            return this.requestBytes;
        }

        @Override
        public long revision() {
            return this.revision;
        }

        @Override
        public DisasterRecoveryRequestMessage build() {
            return new DisasterRecoveryRequestMessageImpl(Objects.requireNonNull(this.requestBytes, "requestBytes is not marked @Nullable"), this.revision);
        }

        @Override
        public DisasterRecoveryRequestMessage buildDeserialized() {
            return new DisasterRecoveryRequestMessageImpl(this.requestBytes, this.revision);
        }
    }
}

