/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessage;
import org.apache.ignite.internal.partition.replicator.network.disaster.DisasterRecoveryRequestMessageBuilder;

class DisasterRecoveryRequestMessageDeserializer
implements MessageDeserializer<DisasterRecoveryRequestMessage> {
    private final DisasterRecoveryRequestMessageBuilder msg;

    DisasterRecoveryRequestMessageDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.disasterRecoveryRequestMessage();
    }

    public Class<DisasterRecoveryRequestMessage> klass() {
        return DisasterRecoveryRequestMessage.class;
    }

    public DisasterRecoveryRequestMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.disasterRecoveryRequestMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("requestBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.requestBytes(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("revision");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.revision(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(DisasterRecoveryRequestMessage.class);
    }
}

