/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommandV2;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommandV2Builder;
import org.apache.ignite.internal.partition.replicator.network.command.WriteIntentSwitchCommandV2Serializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class WriteIntentSwitchCommandV2Impl
implements WriteIntentSwitchCommandV2,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 41;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final Set<Integer> tableIds;
    @IgniteToStringInclude
    private final UUID txId;

    private WriteIntentSwitchCommandV2Impl(boolean commit, HybridTimestamp commitTimestamp, boolean full, HybridTimestamp initiatorTime, int requiredCatalogVersion, HybridTimestamp safeTime, Set<Integer> tableIds, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.safeTime = safeTime;
        this.tableIds = tableIds;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public Set<Integer> tableIds() {
        return this.tableIds;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return WriteIntentSwitchCommandV2Serializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(WriteIntentSwitchCommandV2Impl.class, (Object)this);
    }

    public short messageType() {
        return 41;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WriteIntentSwitchCommandV2Impl otherMessage = (WriteIntentSwitchCommandV2Impl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.tableIds, otherMessage.tableIds) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.full, this.requiredCatalogVersion, this.commitTimestamp, this.initiatorTime, this.safeTime, this.tableIds, this.txId);
        return result;
    }

    public WriteIntentSwitchCommandV2Impl clone() {
        try {
            return (WriteIntentSwitchCommandV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static WriteIntentSwitchCommandV2Builder builder() {
        return new Builder();
    }

    private static class Builder
    implements WriteIntentSwitchCommandV2Builder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private boolean full;
        private HybridTimestamp initiatorTime;
        private int requiredCatalogVersion;
        private HybridTimestamp safeTime;
        private Set<Integer> tableIds;
        private UUID txId;

        private Builder() {
        }

        @Override
        public WriteIntentSwitchCommandV2Builder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder tableIds(Set<Integer> tableIds) {
            Objects.requireNonNull(tableIds, "tableIds is not marked @Nullable");
            this.tableIds = tableIds;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandV2Builder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public Set<Integer> tableIds() {
            return this.tableIds;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public WriteIntentSwitchCommandV2 build() {
            return new WriteIntentSwitchCommandV2Impl(this.commit, this.commitTimestamp, this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.requiredCatalogVersion, this.safeTime, Objects.requireNonNull(this.tableIds, "tableIds is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }

        @Override
        public WriteIntentSwitchCommandV2 buildDeserialized() {
            return new WriteIntentSwitchCommandV2Impl(this.commit, this.commitTimestamp, this.full, this.initiatorTime, this.requiredCatalogVersion, this.safeTime, this.tableIds, this.txId);
        }
    }
}

