/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.partition.replicator.network.command.SecondarySafeTimeSyncCommand;
import org.apache.ignite.internal.partition.replicator.network.command.SecondarySafeTimeSyncCommandBuilder;
import org.apache.ignite.internal.partition.replicator.network.command.SecondarySafeTimeSyncCommandSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SecondarySafeTimeSyncCommandImpl
implements SecondarySafeTimeSyncCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 107;
    @IgniteToStringInclude
    private final HybridTimestamp proposedSafeTime;
    @IgniteToStringInclude
    private final int tableId;

    private SecondarySafeTimeSyncCommandImpl(HybridTimestamp proposedSafeTime, int tableId) {
        this.proposedSafeTime = proposedSafeTime;
        this.tableId = tableId;
    }

    @Override
    public HybridTimestamp proposedSafeTime() {
        return this.proposedSafeTime;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return SecondarySafeTimeSyncCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SecondarySafeTimeSyncCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 107;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SecondarySafeTimeSyncCommandImpl otherMessage = (SecondarySafeTimeSyncCommandImpl)other;
        return Objects.equals(this.proposedSafeTime, otherMessage.proposedSafeTime) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tableId, this.proposedSafeTime);
        return result;
    }

    public SecondarySafeTimeSyncCommandImpl clone() {
        try {
            return (SecondarySafeTimeSyncCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SecondarySafeTimeSyncCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements SecondarySafeTimeSyncCommandBuilder {
        private HybridTimestamp proposedSafeTime;
        private int tableId;

        private Builder() {
        }

        @Override
        public SecondarySafeTimeSyncCommandBuilder proposedSafeTime(HybridTimestamp proposedSafeTime) {
            Objects.requireNonNull(proposedSafeTime, "proposedSafeTime is not marked @Nullable");
            this.proposedSafeTime = proposedSafeTime;
            return this;
        }

        @Override
        public SecondarySafeTimeSyncCommandBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public HybridTimestamp proposedSafeTime() {
            return this.proposedSafeTime;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public SecondarySafeTimeSyncCommand build() {
            return new SecondarySafeTimeSyncCommandImpl(Objects.requireNonNull(this.proposedSafeTime, "proposedSafeTime is not marked @Nullable"), this.tableId);
        }

        @Override
        public SecondarySafeTimeSyncCommand buildDeserialized() {
            return new SecondarySafeTimeSyncCommandImpl(this.proposedSafeTime, this.tableId);
        }
    }
}

