/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.partition.replicator.ReliableCatalogVersions;
import org.apache.ignite.internal.partition.replicator.ReplicaTxFinishMarker;
import org.apache.ignite.internal.partition.replicator.ReplicationRaftCommandApplicator;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandV2Builder;
import org.apache.ignite.internal.partition.replicator.raft.UnexpectedTransactionStateException;
import org.apache.ignite.internal.partition.replicator.schema.ValidationSchemasSource;
import org.apache.ignite.internal.partition.replicator.schemacompat.CompatValidationResult;
import org.apache.ignite.internal.partition.replicator.schemacompat.SchemaCompatibilityValidator;
import org.apache.ignite.internal.raft.Command;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite.internal.schema.SchemaSyncService;
import org.apache.ignite.internal.tx.IncompatibleSchemaAbortException;
import org.apache.ignite.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite.internal.tx.PartitionEnlistment;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite.internal.tx.message.PartitionEnlistmentMessage;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.storage.state.TxStatePartitionStorage;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class TxFinishReplicaRequestHandler {
    private static final IgniteLogger LOG = Loggers.forClass(TxFinishReplicaRequestHandler.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final ClockService clockService;
    private final TxManager txManager;
    private final ZonePartitionId replicationGroupId;
    private final SchemaCompatibilityValidator schemaCompatValidator;
    private final ReliableCatalogVersions reliableCatalogVersions;
    private final ReplicationRaftCommandApplicator raftCommandApplicator;
    private final ReplicaTxFinishMarker replicaTxFinishMarker;

    public TxFinishReplicaRequestHandler(TxStatePartitionStorage txStatePartitionStorage, ClockService clockService, TxManager txManager, ValidationSchemasSource validationSchemasSource, SchemaSyncService schemaSyncService, CatalogService catalogService, RaftCommandRunner raftCommandRunner, ZonePartitionId replicationGroupId) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.clockService = clockService;
        this.txManager = txManager;
        this.replicationGroupId = replicationGroupId;
        this.schemaCompatValidator = new SchemaCompatibilityValidator(validationSchemasSource, catalogService, schemaSyncService);
        this.reliableCatalogVersions = new ReliableCatalogVersions(schemaSyncService, catalogService);
        this.raftCommandApplicator = new ReplicationRaftCommandApplicator(raftCommandRunner, (ReplicationGroupId)replicationGroupId);
        this.replicaTxFinishMarker = new ReplicaTxFinishMarker(txManager);
    }

    public CompletableFuture<TransactionResult> handle(TxFinishReplicaRequest request) {
        Map<ZonePartitionId, PartitionEnlistment> enlistedGroups = TxFinishReplicaRequestHandler.asReplicationGroupIdToPartitionMap(request.groups());
        UUID txId = request.txId();
        if (request.commit()) {
            HybridTimestamp commitTimestamp = request.commitTimestamp();
            return this.schemaCompatValidator.validateCommit(txId, request.tableIds(), commitTimestamp).thenCompose(validationResult -> this.finishAndCleanup(enlistedGroups, validationResult.isSuccessful(), (HybridTimestamp)(validationResult.isSuccessful() ? commitTimestamp : null), txId).thenApply(txResult -> {
                TxFinishReplicaRequestHandler.throwIfSchemaValidationOnCommitFailed(validationResult, txResult);
                return txResult;
            }));
        }
        return this.finishAndCleanup(enlistedGroups, false, null, txId);
    }

    private static Map<ZonePartitionId, PartitionEnlistment> asReplicationGroupIdToPartitionMap(Map<ZonePartitionIdMessage, PartitionEnlistmentMessage> messages) {
        HashMap<ZonePartitionId, PartitionEnlistment> result = new HashMap<ZonePartitionId, PartitionEnlistment>(IgniteUtils.capacity((int)messages.size()));
        for (Map.Entry<ZonePartitionIdMessage, PartitionEnlistmentMessage> e : messages.entrySet()) {
            result.put(e.getKey().asReplicationGroupId(), e.getValue().asPartition());
        }
        return result;
    }

    private CompletableFuture<TransactionResult> finishAndCleanup(Map<ZonePartitionId, PartitionEnlistment> enlistedPartitions, boolean commit, @Nullable HybridTimestamp commitTimestamp, UUID txId) {
        boolean transactionAlreadyFinished;
        TxMeta txMeta = this.txStatePartitionStorage.get(txId);
        boolean bl = transactionAlreadyFinished = txMeta != null && TxState.isFinalState((TxState)txMeta.txState());
        if (transactionAlreadyFinished) {
            if (commit != (txMeta.txState() == TxState.COMMITTED)) {
                LOG.error("Failed to finish a transaction that is already finished [txId={}, expectedState={}, actualState={}].", new Object[]{txId, commit ? TxState.COMMITTED : TxState.ABORTED, txMeta.txState()});
                throw new MismatchingTransactionOutcomeInternalException("Failed to change the outcome of a finished transaction [txId=" + txId + ", txState=" + txMeta.txState() + "].", new TransactionResult(txMeta.txState(), txMeta.commitTimestamp()));
            }
            return CompletableFuture.completedFuture(new TransactionResult(txMeta.txState(), txMeta.commitTimestamp()));
        }
        List<EnlistedPartitionGroup> enlistedPartitionGroups = enlistedPartitions.entrySet().stream().map(entry -> new EnlistedPartitionGroup((ZonePartitionId)entry.getKey(), ((PartitionEnlistment)entry.getValue()).tableIds())).collect(Collectors.toList());
        return this.finishTransaction(enlistedPartitionGroups, txId, commit, commitTimestamp).thenCompose(txResult -> this.txManager.cleanup(this.replicationGroupId, enlistedPartitions, commit, commitTimestamp, txId).thenApply(v -> txResult));
    }

    private static void throwIfSchemaValidationOnCommitFailed(CompatValidationResult validationResult, TransactionResult txResult) {
        if (!validationResult.isSuccessful()) {
            if (validationResult.isTableDropped()) {
                throw new IncompatibleSchemaAbortException(IgniteStringFormatter.format((String)"Commit failed because a table was already dropped [table={}]", (Object[])new Object[]{validationResult.failedTableName()}), txResult);
            }
            if (validationResult.isTableLocked()) {
                throw new MismatchingTransactionOutcomeInternalException(IgniteStringFormatter.format((String)"Commit failed because a table has been locked by an ongoing snapshot restoration [tableName={}]", (Object[])new Object[]{validationResult.failedTableName()}), txResult);
            }
            throw new IncompatibleSchemaAbortException(IgniteStringFormatter.format((String)"Commit failed because schema is not forward-compatible [fromSchemaVersion={}, toSchemaVersion={}, table={}, details={}]", (Object[])new Object[]{validationResult.fromSchemaVersion(), validationResult.toSchemaVersion(), validationResult.failedTableName(), validationResult.details()}), txResult);
        }
    }

    private CompletableFuture<TransactionResult> finishTransaction(Collection<EnlistedPartitionGroup> partitions, UUID txId, boolean commit, @Nullable HybridTimestamp commitTimestamp) {
        assert (!commit || commitTimestamp != null) : "Cannot commit without the timestamp.";
        HybridTimestamp tsForCatalogVersion = commit ? commitTimestamp : this.clockService.now();
        return ((CompletableFuture)this.reliableCatalogVersionFor(tsForCatalogVersion).thenCompose(catalogVersion -> this.applyFinishCommand(txId, commit, commitTimestamp, (int)catalogVersion, TxFinishReplicaRequestHandler.toPartitionInfoMessages(partitions)))).handle((T txOutcome, U ex) -> {
            if (ex != null) {
                if (ex instanceof UnexpectedTransactionStateException) {
                    UnexpectedTransactionStateException utse = (UnexpectedTransactionStateException)((Object)((Object)ex));
                    TransactionResult result = utse.transactionResult();
                    this.replicaTxFinishMarker.markFinished(txId, result.transactionState(), result.commitTimestamp());
                    throw new MismatchingTransactionOutcomeInternalException(utse.getMessage(), utse.transactionResult());
                }
                throw new TransactionException(commit ? ErrorGroups.Transactions.TX_COMMIT_ERR : ErrorGroups.Transactions.TX_ROLLBACK_ERR, ex);
            }
            TransactionResult result = (TransactionResult)txOutcome;
            this.replicaTxFinishMarker.markFinished(txId, result.transactionState(), result.commitTimestamp());
            return result;
        });
    }

    private CompletableFuture<Integer> reliableCatalogVersionFor(HybridTimestamp ts) {
        return this.reliableCatalogVersions.reliableCatalogVersionFor(ts);
    }

    private CompletableFuture<Object> applyFinishCommand(UUID transactionId, boolean commit, @Nullable HybridTimestamp commitTimestamp, int catalogVersion, List<EnlistedPartitionGroupMessage> enlistedPartitions) {
        HybridTimestamp now = this.clockService.now();
        FinishTxCommandV2Builder finishTxCmdBldr = PARTITION_REPLICATION_MESSAGES_FACTORY.finishTxCommandV2().txId(transactionId).commit(commit).initiatorTime(now).requiredCatalogVersion(catalogVersion).partitions(enlistedPartitions);
        if (commit) {
            finishTxCmdBldr.commitTimestamp(commitTimestamp);
        }
        return this.raftCommandApplicator.applyCommandWithExceptionHandling((Command)finishTxCmdBldr.build());
    }

    private static List<EnlistedPartitionGroupMessage> toPartitionInfoMessages(Collection<EnlistedPartitionGroup> partitionIds) {
        ArrayList<EnlistedPartitionGroupMessage> list = new ArrayList<EnlistedPartitionGroupMessage>(partitionIds.size());
        for (EnlistedPartitionGroup enlistedPartitionGroup : partitionIds) {
            list.add(TxFinishReplicaRequestHandler.enlistedPartitionGroupMessage(enlistedPartitionGroup));
        }
        return list;
    }

    private static EnlistedPartitionGroupMessage enlistedPartitionGroupMessage(EnlistedPartitionGroup enlistedPartitionGroup) {
        return TX_MESSAGES_FACTORY.enlistedPartitionGroupMessage().groupId(ReplicaMessageUtils.toZonePartitionIdMessage((ReplicaMessagesFactory)REPLICA_MESSAGES_FACTORY, (ZonePartitionId)enlistedPartitionGroup.groupId())).tableIds(enlistedPartitionGroup.tableIds()).build();
    }
}

