/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.ignite.internal.hlc.HybridTimestampTracker;
import org.apache.ignite.internal.network.ClusterNodeResolver;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.util.CompletableFutures;

public class TxRecoveryEngine {
    private final TxManager txManager;
    private final ClusterNodeResolver clusterNodeResolver;
    private final ZonePartitionId replicationGroupId;
    private final Function<InternalClusterNode, PendingTxPartitionEnlistment> abandonedTxRecoveryEnlistmentFactory;

    public TxRecoveryEngine(TxManager txManager, ClusterNodeResolver clusterNodeResolver, ZonePartitionId replicationGroupId, Function<InternalClusterNode, PendingTxPartitionEnlistment> abandonedTxRecoveryEnlistmentFactory) {
        this.txManager = txManager;
        this.clusterNodeResolver = clusterNodeResolver;
        this.replicationGroupId = replicationGroupId;
        this.abandonedTxRecoveryEnlistmentFactory = abandonedTxRecoveryEnlistmentFactory;
    }

    public CompletableFuture<Void> triggerTxRecovery(UUID txId, UUID senderId) {
        return this.txManager.finish(HybridTimestampTracker.emptyTracker(), this.replicationGroupId, false, false, true, false, Map.of(this.replicationGroupId, this.abandonedTxRecoveryEnlistmentFactory.apply(this.clusterNodeResolver.getById(senderId))), txId).whenComplete((v, ex) -> this.runCleanupOnNode(this.replicationGroupId, txId, senderId));
    }

    public CompletableFuture<Void> runCleanupOnNode(ZonePartitionId commitPartitionId, UUID txId, UUID nodeId) {
        String nodeConsistentId = this.clusterNodeResolver.getConsistentIdById(nodeId);
        return nodeConsistentId == null ? CompletableFutures.nullCompletedFuture() : this.txManager.cleanup(commitPartitionId, nodeConsistentId, txId);
    }
}

